/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stem.model.common.ModelProjectNature;
import org.eclipse.stem.model.ui.MetamodelEditorPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleNatureAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                ToggleNatureAction.toggleNature(project);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public static void toggleNature(IProject project) {
        try {
            if (ModelProjectNature.hasNature((IProject)project)) {
                ModelProjectNature.removeNature((IProject)project);
            } else {
                ModelProjectNature.addNature((IProject)project);
            }
        }
        catch (CoreException ce) {
            MetamodelEditorPlugin.log((IStatus)new Status(4, "org.eclipse.stem.model.ui", "Error toggling nature", (Throwable)ce));
        }
    }
}

