/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.ui.wizards.ModelCompartmentsPage;
import org.eclipse.stem.model.ui.wizards.ModelParametersPage;
import org.eclipse.stem.model.ui.wizards.ModelPropertiesPage;
import org.eclipse.stem.model.ui.wizards.ModelTransitionsPage;
import org.eclipse.swt.widgets.Shell;

public class NewModelWizard
extends Wizard {
    protected ModelPropertiesPage propertiesPage;
    protected ModelParametersPage parametersPage;
    protected ModelCompartmentsPage compartmentsPage;
    protected ModelTransitionsPage transitionsPage;
    protected boolean showTransitionsPage = true;
    protected boolean forceUniqueName = true;
    protected Model newModel;
    protected Package metamodel;

    public NewModelWizard(Model model, Package metamodel) {
        this(model, metamodel, false, false);
    }

    public NewModelWizard(Model model, Package metamodel, boolean showTransitionsPage, boolean forceUniqueName) {
        this.setNeedsProgressMonitor(true);
        this.newModel = model;
        this.metamodel = metamodel;
        this.showTransitionsPage = showTransitionsPage;
        this.forceUniqueName = forceUniqueName;
    }

    public Model getModel() {
        return this.newModel;
    }

    public void addPages() {
        this.propertiesPage = new ModelPropertiesPage(this.newModel, this.metamodel, this.forceUniqueName);
        this.parametersPage = new ModelParametersPage(this.newModel);
        this.compartmentsPage = new ModelCompartmentsPage(this.newModel);
        this.addPage((IWizardPage)this.propertiesPage);
        this.addPage((IWizardPage)this.parametersPage);
        this.addPage((IWizardPage)this.compartmentsPage);
        if (this.showTransitionsPage) {
            this.transitionsPage = new ModelTransitionsPage(this.newModel);
            this.addPage((IWizardPage)this.transitionsPage);
        }
    }

    public boolean performFinish() {
        if (this.transitionsPage != null && !this.transitionsPage.validatePage()) {
            return false;
        }
        this.propertiesPage.formatTextFields();
        boolean valid = true;
        String errorMessage = null;
        if (valid && !this.propertiesPage.validatePage()) {
            errorMessage = this.propertiesPage.getErrorMessage();
            valid = false;
        }
        if (valid && !this.compartmentsPage.validatePage()) {
            errorMessage = this.compartmentsPage.getErrorMessage();
            valid = false;
        }
        if (!valid) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error saving the model: " + errorMessage));
            return false;
        }
        return true;
    }
}

