/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.solver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyEditor;
import org.eclipse.stem.core.solver.SolverPropertyEditorAdapter;
import org.eclipse.stem.core.solver.SolverPropertyEditorAdapterFactory;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SolverPropertyComposite
extends Composite {
    private Map<Solver, SolverPropertyEditor> modelMap = new HashMap<Solver, SolverPropertyEditor>();
    private StackLayout stackLayout = new StackLayout();
    Solver solver;

    public SolverPropertyComposite(Composite parent, int style, Solver[] solvers, ModifyListener projectValidator) {
        super(parent, style);
        this.setLayout((Layout)this.stackLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("SPC1"));
        SolverPropertyEditor firstOne = null;
        if (solvers != null) {
            int i = 0;
            while (i < solvers.length) {
                SolverPropertyEditorAdapter spea = (SolverPropertyEditorAdapter)SolverPropertyEditorAdapterFactory.INSTANCE.adapt((Notifier)solvers[i], SolverPropertyEditorAdapter.class);
                SolverPropertyEditor spe = spea.createSolverPropertyEditor(this, 0, projectValidator);
                this.modelMap.put(solvers[i], spe);
                if (firstOne == null) {
                    firstOne = spe;
                }
                ++i;
            }
        }
        this.stackLayout.topControl = firstOne;
    }

    public void displaySolver(Solver solver) {
        this.solver = solver;
        SolverPropertyEditor spe = this.modelMap.get(solver);
        if (spe != null) {
            this.stackLayout.topControl = spe;
            this.layout();
        } else {
            Activator.logError(String.valueOf(Messages.getString("SPC2")) + solver.getClass().getName() + "\"", null);
        }
    }

    public Solver getSelectedSolver() {
        return this.solver;
    }

    public Solver createSolver() {
        SolverPropertyEditor spe = (SolverPropertyEditor)this.stackLayout.topControl;
        return spe.createAndPopulateSolver();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return ((SolverPropertyEditor)this.stackLayout.topControl).validate();
    }

    public String getErrorMessage() {
        return ((SolverPropertyEditor)this.stackLayout.topControl).getErrorMessage();
    }

    public void populateSolver(Solver solver) {
        ((SolverPropertyEditor)this.stackLayout.topControl).populate(solver);
    }
}

