/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.modifier.FeatureModifier;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.modifier.ModifierFactory;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.newmodifierpage.NewModifierPageAdapter;
import org.eclipse.stem.ui.adapters.newmodifierpage.NewModifierPageAdapterFactory;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.NewModifierPage;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewModifierWizard
extends NewIdentifiableWizard {
    private EObject target;
    private NewModifierPage newModifierPage;

    @Override
    protected String getWizardTitle() {
        return Messages.getString("NModifierWiz.wizard_title");
    }

    @Override
    protected NewIdentifiablePage createNewIdentifiablePage() {
        NewModifierPageAdapter adapter = (NewModifierPageAdapter)NewModifierPageAdapterFactory.INSTANCE.adapt((Notifier)this.target, NewModifierPageAdapter.class);
        if (adapter != null) {
            adapter.setTarget((Notifier)this.target);
            this.newModifierPage = adapter.createNewModifierPage();
        } else {
            Activator.logError("Internal Error: could not create NewModifierPage for \"" + this.target.getClass().getName() + "\"", null);
            this.newModifierPage = new NewModifierPage(this.target){

                @Override
                protected Composite createSpecificComposite(Composite parent) {
                    return null;
                }
            };
        }
        this.setHelpContextId("org.eclipse.stem.doc.newmodifier_contextid");
        return this.newModifierPage;
    }

    @Override
    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            @Override
            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/modifier.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.MODIFIER_TYPE_URI.toString());
                this.type.setEnabled(false);
                this.titleTextField.setText(Messages.getString("dc_title_mod"));
                this.source.setText(Messages.getString("dc_source_mod"));
                this.descriptionTextField.setText(Messages.getString("dc_desc_mod"));
            }
        };
    }

    @Override
    protected Identifiable createIdentifiable() {
        Modifier retValue = ModifierFactory.eINSTANCE.createModifier();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        if (this.target instanceof Edge) {
            Edge edge = (Edge)this.target;
            retValue.setTargetURI(edge.getLabel().getURI());
        } else if (this.target instanceof Identifiable) {
            retValue.setTargetURI(((Identifiable)this.target).getURI());
        } else if (this.target instanceof FeatureModifier) {
            Modifier mod = (Modifier)((FeatureModifier)this.target).eContainer();
            int index = mod.getFeatureModifiers().indexOf((Object)this.target);
            URI uri = mod.getURI();
            retValue.setTargetURI(URI.createURI((String)(uri + "?" + index)));
        } else {
            retValue.setTargetURI(null);
        }
        retValue.getFeatureModifiers().addAll(this.newModifierPage.getFeatureModifiers());
        return retValue;
    }

    @Override
    protected String getSerializationFolderName() {
        return "modifiers";
    }

    @Override
    protected String getSerializationFileNameExtension() {
        return "modifier";
    }

    public final void setTarget(EObject target) {
        this.target = target;
    }

    public static class NewModifierWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
            if (selection instanceof StructuredSelection) {
                try {
                    Object obj = ((StructuredSelection)selection).toArray()[0];
                    EObject target = null;
                    if (obj instanceof DelegatingWrapperItemProvider) {
                        target = this.unravel((DelegatingWrapperItemProvider)obj);
                    } else if (obj instanceof EObject) {
                        target = (EObject)obj;
                    }
                    if (target != null) {
                        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
                        NewModifierWizard wizard = new NewModifierWizard();
                        wizard.setTarget(target);
                        wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                        STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
                        wizardDialog.open();
                    } else {
                        Activator.logError("Internal error: attempting to create Modifier Wizard for \"" + obj.getClass().getName() + "\"", null);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            return null;
        }

        EObject unravel(DelegatingWrapperItemProvider obj) {
            if (obj.getValue() instanceof DelegatingWrapperItemProvider) {
                return this.unravel((DelegatingWrapperItemProvider)obj.getValue());
            }
            return (EObject)obj.getValue();
        }
    }
}

