/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

public class PhaseSpaceCoordinate
implements Comparable {
    double xValue;
    double yValue;

    public PhaseSpaceCoordinate(double x, double y) {
        this.xValue = x;
        this.yValue = y;
    }

    public double getXValue() {
        return this.xValue;
    }

    public void setXValue(double value) {
        this.xValue = value;
    }

    public double getYValue() {
        return this.yValue;
    }

    public void setYValue(double value) {
        this.yValue = value;
    }

    public void integratePath(double deltaXvalue, double deltaYvalue) {
        this.xValue += deltaXvalue;
        this.yValue += deltaYvalue;
    }

    public void normalize(double normalization) {
        this.xValue /= normalization;
        this.yValue /= normalization;
    }

    public double getDistance(PhaseSpaceCoordinate otherPoint) {
        double dist2 = (this.xValue - otherPoint.xValue) * (this.xValue - otherPoint.xValue) + (this.yValue - otherPoint.yValue) * (this.yValue - otherPoint.yValue);
        double dist = Math.sqrt(dist2);
        return dist;
    }

    public int compareTo(Object otherCoord) throws ClassCastException {
        if (!(otherCoord instanceof PhaseSpaceCoordinate)) {
            throw new ClassCastException("A Person object expected.");
        }
        double otherX = ((PhaseSpaceCoordinate)otherCoord).xValue;
        if (this.xValue < otherX) {
            return -1;
        }
        if (this.xValue > otherX) {
            return 1;
        }
        return 0;
    }
}

