/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtend.core.scoping.KnownTypesScope;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyKnownTypesScope
extends KnownTypesScope {
    private final List<QualifiedName> importNames;

    public LegacyKnownTypesScope(List<JvmType> types, List<QualifiedName> importNames, AbstractScope parent) {
        super(types, parent);
        this.importNames = importNames;
    }

    @Override
    protected boolean isMatch(int index, JvmType type, String simpleName, QualifiedName relativeName) {
        return super.isMatch(index, type, simpleName, relativeName) || this.isLegacyMatch(index, relativeName);
    }

    protected boolean isLegacyMatch(int index, QualifiedName relativeName) {
        QualifiedName importedName = this.importNames.get(index);
        return importedName != null && relativeName.getSegmentCount() == 1 && importedName.getLastSegment().equals(relativeName.getFirstSegment());
    }

    @Override
    protected JvmType getUnambiguousResult(JvmType current, int currentIndex, JvmType next, int nextIndex, QualifiedName relativeName) {
        if (current != null && current != next) {
            JvmType realCurrentType;
            if (this.isLegacyMatch(currentIndex, relativeName)) {
                if (this.isLegacyMatch(nextIndex, relativeName)) {
                    return null;
                }
                JvmType realNextType = this.findNestedType(next, nextIndex, relativeName);
                if (realNextType == current) {
                    return current;
                }
            } else if (this.isLegacyMatch(nextIndex, relativeName) && (realCurrentType = this.findNestedType(current, currentIndex, relativeName)) == next) {
                return next;
            }
            return null;
        }
        return next;
    }

    @Override
    protected void doGetDescriptions(JvmType type, JvmType knownType, int index, List<IEObjectDescription> result) {
        super.doGetDescriptions(type, knownType, index, result);
        QualifiedName importName = this.importNames.get(index);
        if (type == knownType && importName != null) {
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)importName.getLastSegment()), (EObject)type));
        }
    }

    @Override
    protected JvmType findNestedType(JvmType result, int index, QualifiedName name) {
        QualifiedName importName;
        if (result.eContainer() instanceof JvmDeclaredType && name.getSegmentCount() == 1 && (importName = this.importNames.get(index)) != null && importName.getLastSegment().equals(name.getFirstSegment())) {
            return result;
        }
        return super.findNestedType(result, index, name);
    }
}

