/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.math;

import java.util.Random;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public class BinomialDistributionUtil {
    public static int MAX_N = 2000000000;
    protected Random rand = new Random();

    public BinomialDistributionUtil(long seed) {
        this.rand.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.rand.setSeed(seed);
    }

    public int fastPickFromBinomialDist(double p, int n) {
        int result = 0;
        if (p == 0.0) {
            return result;
        }
        if (Double.isInfinite(p) || Double.isNaN(p)) {
            return result;
        }
        double rndVal = this.rand.nextDouble();
        boolean success = false;
        if (n < MAX_N) {
            BinomialDistribution bdist = new BinomialDistribution((RandomGenerator)new JDKRandomGenerator(), n, p);
            result = bdist.inverseCumulativeProbability(rndVal);
            success = true;
        }
        if (!success) {
            result = (int)Math.round((double)n * p);
        }
        return result;
    }
}

