/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.gis.coord;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.eclipse.stem.gis.GisUtils;
import org.eclipse.stem.gis.coord.CoordinateSystem;
import org.eclipse.stem.gis.coord.Ellipsoid;
import org.eclipse.stem.gis.coord.GeographicCoordinateSystem;
import org.eclipse.stem.gis.coord.ProjectedCoordinateSystem;
import org.eclipse.stem.gis.proj.ESRIProjectionFactory;

public class CoordinateSystemLoader {
    public static CoordinateSystem loadFromPrj(File file) throws IOException {
        CoordinateSystem coordinateSystem;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            coordinateSystem = CoordinateSystemLoader.loadFromPrj(is);
        }
        catch (Throwable throwable) {
            GisUtils.safeClose(is);
            throw throwable;
        }
        GisUtils.safeClose(is);
        return coordinateSystem;
    }

    public static CoordinateSystem loadFromPrj(InputStream is) throws IOException {
        PrjParser parser = new PrjParser(is);
        CoordinateSystemParseTree parseResults = parser.parse();
        return CoordinateSystemLoader.loadFromParser(parseResults);
    }

    private static CoordinateSystem loadFromParser(CoordinateSystemParseTree node) {
        if (node.getValue().equals("GEOGCS")) {
            return CoordinateSystemLoader.parseGeographicCoordinateSystem(node);
        }
        if (node.getValue().equals("PROJCS")) {
            return CoordinateSystemLoader.parseProjectedCoordinateSystem(node);
        }
        return null;
    }

    private static Ellipsoid parseSpheroid(CoordinateSystemParseTree node) {
        String name = node.getChildren().get(0).getValue();
        double majorAxis = Double.valueOf(node.getChildren().get(1).getValue());
        double flattening = Double.valueOf(node.getChildren().get(2).getValue());
        Ellipsoid retVal = Ellipsoid.getForName(name);
        if (retVal == null) {
            retVal = new Ellipsoid(majorAxis, flattening);
        }
        return retVal;
    }

    private static Ellipsoid parseDatum(CoordinateSystemParseTree node) {
        Ellipsoid retVal = null;
        for (CoordinateSystemParseTree child : node.getChildren()) {
            if (!child.getValue().equals("SPHEROID")) continue;
            retVal = CoordinateSystemLoader.parseSpheroid(child);
        }
        return retVal;
    }

    private static ProjectedCoordinateSystem parseProjectedCoordinateSystem(CoordinateSystemParseTree node) {
        String name = node.getChildren().get(0).getValue();
        String projectionName = null;
        Properties props = new Properties();
        double unitScalar = 0.0;
        GeographicCoordinateSystem gcs = null;
        for (CoordinateSystemParseTree child : node.getChildren()) {
            if (child.getValue().equals("GEOGCS")) {
                gcs = CoordinateSystemLoader.parseGeographicCoordinateSystem(child);
                continue;
            }
            if (child.getValue().equals("PROJECTION")) {
                projectionName = child.getChildren().get(0).getValue();
                continue;
            }
            if (child.getValue().equals("UNIT")) {
                unitScalar = Double.valueOf(((CoordinateSystemParseTree)child.children.get(1)).getValue());
                continue;
            }
            if (!child.getValue().equals("PARAMETER")) continue;
            String paramName = child.getChildren().get(0).getValue();
            String paramValue = child.getChildren().get(1).getValue();
            props.put(paramName, paramValue);
        }
        ProjectedCoordinateSystem projCS = new ProjectedCoordinateSystem(name, gcs, projectionName, unitScalar, props);
        projCS.setProjection(ESRIProjectionFactory.getForCoordinateSystem(projCS));
        return projCS;
    }

    private static GeographicCoordinateSystem parseGeographicCoordinateSystem(CoordinateSystemParseTree node) {
        String name = node.getChildren().get(0).getValue();
        double primeMeridanOffset = 0.0;
        double unitScalar = 0.0;
        Ellipsoid datum = null;
        for (CoordinateSystemParseTree child : node.getChildren()) {
            if (child.getValue().equals("DATUM")) {
                datum = CoordinateSystemLoader.parseDatum(child);
                continue;
            }
            if (child.getValue().equals("PRIMEM")) {
                primeMeridanOffset = Double.valueOf(child.getChildren().get(1).getValue());
                continue;
            }
            if (!child.getValue().equals("UNIT")) continue;
            unitScalar = Double.valueOf(child.getChildren().get(1).getValue());
        }
        return new GeographicCoordinateSystem(name, datum, primeMeridanOffset, unitScalar);
    }

    private static class CoordinateSystemParseTree {
        private String value;
        private List<CoordinateSystemParseTree> children;

        CoordinateSystemParseTree(String name) {
            this.value = name;
        }

        void addChild(CoordinateSystemParseTree node) {
            if (this.children == null) {
                this.children = new ArrayList<CoordinateSystemParseTree>();
            }
            this.children.add(node);
        }

        void addChild(String name) {
            this.addChild(new CoordinateSystemParseTree(name));
        }

        String getValue() {
            return this.value;
        }

        List<CoordinateSystemParseTree> getChildren() {
            return this.children;
        }
    }

    private static class PrjParser {
        private String inputData;

        public PrjParser(InputStream is) throws IOException {
            this.read(is);
            this.parse();
        }

        public CoordinateSystemParseTree parse() {
            return this.getParseTree();
        }

        private CoordinateSystemParseTree getParseTree() {
            String data = this.inputData;
            Stack<CoordinateSystemParseTree> history = new Stack<CoordinateSystemParseTree>();
            CoordinateSystemParseTree currentNode = null;
            StringBuilder currentFieldData = new StringBuilder();
            int idx = 0;
            while (idx < data.length()) {
                char c = data.charAt(idx);
                if (c == '[') {
                    if (currentNode != null) {
                        history.push(currentNode);
                    }
                    currentNode = new CoordinateSystemParseTree(currentFieldData.toString());
                    currentFieldData = new StringBuilder();
                } else if (c == ']') {
                    if (currentFieldData.length() > 0) {
                        currentNode.addChild(this.cleanup(currentFieldData.toString()));
                    }
                    if (history.size() > 0) {
                        CoordinateSystemParseTree tmp = (CoordinateSystemParseTree)history.pop();
                        tmp.addChild(currentNode);
                        currentNode = tmp;
                    }
                    currentFieldData = new StringBuilder();
                } else if (c == ',') {
                    if (currentFieldData.length() > 0) {
                        currentNode.addChild(this.cleanup(currentFieldData.toString()));
                    }
                    currentFieldData = new StringBuilder();
                } else {
                    currentFieldData.append(c);
                }
                ++idx;
            }
            return currentNode;
        }

        private String cleanup(String str) {
            return str.replaceAll("\"", "");
        }

        private void read(InputStream is) throws IOException {
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[1024];
            int read = 0;
            while ((read = is.read(buf)) > 0) {
                sb.append(new String(buf, 0, read));
            }
            this.inputData = sb.toString().trim();
        }
    }
}

