/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphgenerators.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.gis.ShapefileReader;
import org.eclipse.stem.gis.dbf.DbfFieldDef;
import org.eclipse.stem.gis.dbf.DbfRecord;
import org.eclipse.stem.gis.shp.ShpRecord;

public class Reader {
    private List<ShpRecord> records;
    private List<String> columnNames;
    private List<List<String>> data;

    public Reader(String shapefileName) throws IOException {
        ShapefileReader reader = new ShapefileReader(new File(shapefileName));
        List fields = reader.getTableHeader().getFieldDefinitions();
        this.records = new ArrayList<ShpRecord>();
        this.columnNames = new ArrayList<String>();
        this.data = new ArrayList<List<String>>();
        while (reader.hasMoreRecords()) {
            ShpRecord shp = reader.getNextRecord();
            DbfRecord dbfr = shp.getTableAttributes();
            if (dbfr != null) {
                List dbfData = dbfr.getData();
                ArrayList<String> row = new ArrayList<String>();
                if (dbfData != null && dbfData.size() > 0 && shp != null) {
                    for (Object o : dbfData) {
                        row.add(o.toString());
                    }
                    this.records.add(shp);
                    this.data.add(row);
                    continue;
                }
                Activator.logInformation((String)"Warning: Shape file contains null entries. Null Entries Ignored");
                continue;
            }
            Activator.logInformation((String)"Warning: Shape file Table attributes are null. Null Entries Ignored");
        }
        for (DbfFieldDef f : fields) {
            this.columnNames.add(f.getFieldName().trim());
        }
    }

    public List<ShpRecord> getShapeList() {
        return this.records;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<List<String>> getData() {
        return this.data;
    }
}

