/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.loggers.csv.CSVLogger;
import org.eclipse.stem.loggers.csv.CSVPackage;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.SimulationLoggerPropertyEditor;
import org.eclipse.stem.ui.wizards.CSVLoggerWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class CSVLoggerPropertyEditor
extends SimulationLoggerPropertyEditor {
    public CSVLoggerPropertyEditor(Composite parent, int style, Logger logger, ModifyListener projectValidator, IProject project) {
        super(parent, style, logger, projectValidator, project);
    }

    public boolean isUserSpecifiedProperty(EStructuralFeature feature) {
        return super.isUserSpecifiedProperty(feature);
    }

    public void populate(Logger logger) {
        super.populate(logger);
        if (logger instanceof CSVLogger) {
            CSVLogger obj = (CSVLogger)logger;
            obj.setLogInitialState(((Button)this.booleanMap.get(CSVPackage.Literals.CSV_LOGGER__LOG_INITIAL_STATE)).getSelection());
            obj.setDataPath(((Text)this.map.get(CSVPackage.Literals.CSV_LOGGER__DATA_PATH)).getText());
            obj.setUseDefaultLogDirectory(((Button)this.booleanMap.get(CSVPackage.Literals.CSV_LOGGER__USE_DEFAULT_LOG_DIRECTORY)).getSelection());
            obj.setLogRunParameters(((Button)this.booleanMap.get(CSVPackage.Literals.CSV_LOGGER__LOG_RUN_PARAMETERS)).getSelection());
            obj.setLogHtmlSummary(((Button)this.booleanMap.get(CSVPackage.Literals.CSV_LOGGER__LOG_HTML_SUMMARY)).getSelection());
            obj.setBufferSize(Integer.parseInt(((Text)this.map.get(CSVPackage.Literals.CSV_LOGGER__BUFFER_SIZE)).getText()));
            obj.setDelimeter(((Text)this.map.get(CSVPackage.Literals.CSV_LOGGER__DELIMETER)).getText());
        }
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Button button = (Button)this.booleanMap.get(CSVPackage.Literals.CSV_LOGGER__USE_DEFAULT_LOG_DIRECTORY);
        Text text = (Text)this.map.get(CSVPackage.Literals.CSV_LOGGER__DATA_PATH);
        if (text != null && button != null && !button.getSelection() && text.getText().equals("")) {
            this.errorMessage = CSVLoggerWizardMessages.getString("LPE_InvalidLogDirectory");
            return false;
        }
        text = (Text)this.map.get(CSVPackage.Literals.CSV_LOGGER__BUFFER_SIZE);
        if (text != null && (text.getText().equals("") || !this.isValidIntValue(text.getText(), 0))) {
            this.errorMessage = CSVLoggerWizardMessages.getString("LPE_InvalidBufferSize");
            return false;
        }
        text = (Text)this.map.get(CSVPackage.Literals.CSV_LOGGER__DELIMETER);
        if (text != null && text.getText().equals("")) {
            this.errorMessage = CSVLoggerWizardMessages.getString("LPE_InvalidDelimeter");
            return false;
        }
        return true;
    }
}

