/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.controls;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.model.ctdl.ui.embed.EmbeddedExpressionEditorComposite;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.MetamodelPackage;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.metamodel.provider.ModelItemProvider;
import org.eclipse.stem.model.ui.editor.ModelDiagramEditor;
import org.eclipse.stem.model.ui.editor.parts.ModelElementEditPart;
import org.eclipse.stem.model.ui.editor.parts.TransitionElementEditPart;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.stem.model.ui.editor.vismodel.TransitionElement;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class TransitionEditorComposite
extends Composite
implements ISelectionListener,
ISelectionChangedListener {
    private ModelDiagramEditor diagramEditor;
    private TransitionElement selectedTransition;
    private ModelElement selectedModel;
    private EmbeddedExpressionEditorComposite embeddedEditor;
    private ComboViewer transitionsComboViewer;
    private CheckboxTableViewer forIncidenceViewer;
    ModelItemProvider modelProvider;
    final Adapter notifier = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
        }
    };

    public TransitionEditorComposite(ModelDiagramEditor editor, Composite parent, int style) {
        super(parent, style);
        this.diagramEditor = editor;
        this.setLayout((Layout)new GridLayout(3, false));
        this.setupTransitionCombo();
        this.setupForIncidenceTable();
        this.setupExpressionEditor();
        this.diagramEditor.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.diagramEditor.addModelSelectionListener(this);
    }

    protected void setupTransitionCombo() {
        Label transitionLabel = new Label((Composite)this, 0);
        transitionLabel.setText("Transition");
        this.transitionsComboViewer = new ComboViewer((Composite)this, 8);
        GridData comboGD = new GridData();
        comboGD.minimumWidth = 100;
        comboGD.widthHint = 100;
        comboGD.horizontalSpan = 2;
        this.transitionsComboViewer.getCombo().setLayoutData((Object)comboGD);
        this.transitionsComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.transitionsComboViewer.setLabelProvider((IBaseLabelProvider)new TransitionNameLabelProvider());
        this.transitionsComboViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.transitionsComboViewer.setInput(Collections.emptyList());
    }

    protected void setupForIncidenceTable() {
    }

    protected void setupExpressionEditor() {
        Label expressionLabel = new Label((Composite)this, 0);
        expressionLabel.setText("Expression");
        GridData labelGD = new GridData();
        labelGD.horizontalSpan = 2;
        expressionLabel.setLayoutData((Object)labelGD);
        Label forIncidenceLabel = new Label((Composite)this, 0);
        forIncidenceLabel.setText("For Incidence");
        this.embeddedEditor = new EmbeddedExpressionEditorComposite((Composite)this, 0);
        GridData editorGD = new GridData(1808);
        editorGD.horizontalSpan = 2;
        this.embeddedEditor.setLayoutData((Object)editorGD);
        this.forIncidenceViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2564);
        GridData forIncidenceGD = new GridData(1040);
        forIncidenceGD.minimumWidth = 100;
        forIncidenceGD.widthHint = 100;
        forIncidenceGD.heightHint = 25;
        forIncidenceGD.minimumHeight = 25;
        this.forIncidenceViewer.getControl().setLayoutData((Object)forIncidenceGD);
        this.forIncidenceViewer.setContentProvider((IContentProvider)new IncidenceCompartmentContentProvider());
        this.forIncidenceViewer.setLabelProvider((IBaseLabelProvider)new CompartmentNameLabelProvider());
        this.forIncidenceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TransitionEditorComposite.this.setIncidenceCompartments();
            }
        });
        this.forIncidenceViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TransitionEditorComposite.this.setIncidenceCompartments();
            }
        });
        this.forIncidenceViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return TransitionEditorComposite.this.selectedTransition == null;
            }

            public boolean isChecked(Object element) {
                return TransitionEditorComposite.this.selectedTransition != null && TransitionEditorComposite.this.selectedTransition.getTransition().getForIncidence() != null && TransitionEditorComposite.this.selectedTransition.getTransition().getForIncidence().contains(element);
            }
        });
        this.forIncidenceViewer.getTable().setEnabled(false);
        this.forIncidenceViewer.setInput(new Object());
    }

    private void setIncidenceCompartments() {
        Object[] elements = this.forIncidenceViewer.getCheckedElements();
        List<Object> selected = null;
        selected = elements != null && elements.length > 0 ? Arrays.asList(elements) : Collections.emptyList();
        EditingDomain domain = this.diagramEditor.getMetamodelEditingDomain();
        domain.getCommandStack().execute(SetCommand.create((EditingDomain)domain, (Object)this.selectedTransition.getTransition(), (Object)MetamodelPackage.Literals.TRANSITION__FOR_INCIDENCE, selected));
    }

    public void dispose() {
        this.diagramEditor.removeModelSelectionListener(this);
        this.diagramEditor.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.embeddedEditor.dispose();
        this.embeddedEditor = null;
        this.diagramEditor = null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selected = ((StructuredSelection)event.getSelection()).getFirstElement();
        if (selected instanceof TransitionElement) {
            this.setTransition((TransitionElement)selected);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            Object selected = ((StructuredSelection)selection).getFirstElement();
            if (selected instanceof TransitionElementEditPart) {
                this.setTransition((TransitionElement)((TransitionElementEditPart)((Object)selected)).getModel());
            } else if (selected instanceof ModelElementEditPart) {
                this.setModel((ModelElement)((ModelElementEditPart)((Object)selected)).getModel());
            } else if (selected instanceof ModelElement) {
                this.setModel((ModelElement)selected);
            }
        }
    }

    protected void setModel(ModelElement model) {
        if (this.selectedModel == model || this.transitionsComboViewer.getCombo().isDisposed()) {
            return;
        }
        this.selectedModel = model;
        if (this.selectedModel != null) {
            AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)this.diagramEditor.getMetamodelEditingDomain();
            this.modelProvider = (ModelItemProvider)domain.getAdapterFactory().adapt((Notifier)model.getModel(), IItemPropertySource.class);
            this.modelProvider.addListener(new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(null) == 5) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                TransitionEditorComposite.this.refresh();
                            }
                        });
                    }
                }
            });
            this.transitionsComboViewer.setInput(model.getTransitionElements());
            this.forIncidenceViewer.setInput((Object)model.getModel());
        } else {
            this.transitionsComboViewer.setInput(Collections.emptyList());
        }
        this.refresh();
        this.forIncidenceViewer.getTable().setEnabled(false);
        TransitionElement nextTransition = null;
        if (this.selectedTransition != null && this.selectedTransition.getTransition() != null) {
            for (TransitionElement te : model.getTransitionElements()) {
                if (!this.matchesSelectedTransition(te)) continue;
                nextTransition = te;
                break;
            }
        }
        if (nextTransition == null && model.getTransitionElements().size() > 0) {
            nextTransition = (TransitionElement)model.getTransitionElements().iterator().next();
        }
        if (nextTransition != null) {
            this.setTransition(nextTransition);
        }
    }

    protected boolean matchesSelectedTransition(TransitionElement te) {
        if (this.selectedTransition == null || this.selectedTransition.getTransition() == null || te == null || te.getTransition() == null) {
            return false;
        }
        Compartment source1 = this.selectedTransition.getTransition().getSource();
        Compartment source2 = te.getTransition().getSource();
        Compartment target1 = this.selectedTransition.getTransition().getTarget();
        Compartment target2 = te.getTransition().getTarget();
        if (source1 == null || source2 == null || target1 == null || target2 == null) {
            return false;
        }
        return source1.getName().equals(source2.getName()) && target1.getName().equals(target2.getName());
    }

    protected void setTransition(TransitionElement transition) {
        if (this.selectedTransition == transition) {
            return;
        }
        if (this.selectedTransition != null && this.selectedTransition.getTransition() != null) {
            this.selectedTransition.getTransition().eAdapters().remove((Object)this.notifier);
        }
        this.selectedTransition = transition;
        if (this.selectedTransition != null) {
            this.forIncidenceViewer.getControl().setEnabled(true);
            this.transitionsComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedTransition));
            this.embeddedEditor.setTransition(transition.getTransition(), this.diagramEditor.getMetamodelEditingDomain());
            this.selectedTransition.getTransition().eAdapters().add((Object)this.notifier);
        } else {
            this.embeddedEditor.setTransition(null, null);
            this.forIncidenceViewer.setCheckedElements(new Object[0]);
            this.forIncidenceViewer.getTable().setEnabled(false);
        }
        this.refresh();
    }

    public void refresh() {
        this.transitionsComboViewer.refresh();
        this.forIncidenceViewer.refresh();
    }

    private static class CompartmentNameLabelProvider
    extends LabelProvider {
        private CompartmentNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Compartment) {
                return ((Compartment)element).getName();
            }
            return "";
        }
    }

    private static class IncidenceCompartmentContentProvider
    implements IStructuredContentProvider {
        private IncidenceCompartmentContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Model) {
                List incidenceCompartments = WizardHelper.getAllIncidenceCompartmentsForModel((Model)((Model)inputElement));
                return incidenceCompartments.toArray();
            }
            return new Object[0];
        }
    }

    private static class TransitionNameLabelProvider
    extends LabelProvider {
        private TransitionNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TransitionElement) {
                Transition t = ((TransitionElement)element).getTransition();
                String source = "?";
                String target = "?";
                if (t != null) {
                    if (t.getSource() != null) {
                        source = t.getSource().getName();
                    }
                    if (t.getTarget() != null) {
                        target = t.getTarget().getName();
                    }
                }
                return String.valueOf(source) + " -> " + target;
            }
            return "";
        }
    }
}

