/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.populationmodels.standard.SinModulatePopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelValueImpl;

public class SinModulatePopulationModelImpl
extends StandardPopulationModelImpl
implements SinModulatePopulationModel {
    protected static final double PHASE_SHIFT_EDEFAULT = 0.0;
    protected double phaseShift = 0.0;
    protected static final double PERIOD_SIN_EDEFAULT = 365.25;
    protected double periodSin = 365.25;
    protected static final double MAX_BOUND_EDEFAULT = 1.0;
    protected double maxBound = 1.0;
    protected static final double MIN_BOUND_EDEFAULT = 0.0;
    protected double minBound = 0.0;

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedBirthRate = this.adjustRate(this.getBirthRate(), this.getTimePeriod(), timeDelta);
        double adjustedDeathRate = this.adjustRate(this.getDeathRate(), this.getTimePeriod(), timeDelta);
        double adjustedPeriod = this.getPeriodSin() * ((double)this.getTimePeriod() / (double)timeDelta);
        double adjustedPhase = this.getPhaseShift() * ((double)this.getTimePeriod() / (double)timeDelta);
        for (DynamicLabel label : labels) {
            StandardPopulationModelLabelImpl slabel = (StandardPopulationModelLabelImpl)label;
            StandardPopulationModelLabelValueImpl delta = (StandardPopulationModelLabelValueImpl)slabel.getDeltaValue();
            StandardPopulationModelLabelValue current = (StandardPopulationModelLabelValue)slabel.getProbeValue();
            double currentPopulation = current.getCount();
            double period = adjustedPeriod;
            double max = this.getMaxBound();
            double min = this.getMinBound();
            double mean = (max + min) / 2.0;
            double Birth_Rate = adjustedBirthRate;
            double Death_Rate = adjustedDeathRate;
            double POP_COUNT = (max - mean) * Math.sin(Math.PI * 2 * (t + adjustedPhase) / period) + mean;
            double POP_DELTA = POP_COUNT - currentPopulation;
            double births = Birth_Rate * currentPopulation;
            double deaths = Death_Rate * currentPopulation;
            if (POP_DELTA > 0.0) {
                births += POP_DELTA / 2.0;
                if ((deaths -= POP_DELTA / 2.0) < 0.0) {
                    births -= deaths;
                    deaths = 0.0;
                }
            } else if (POP_DELTA < 0.0) {
                births += POP_DELTA / 2.0;
                deaths -= POP_DELTA / 2.0;
                if (births < 0.0) {
                    deaths -= births;
                    births = 0.0;
                }
            }
            delta.setCount(POP_DELTA);
            delta.setBirths(births);
            delta.setDeaths(deaths);
            this.computeAdditionalDeltasAndExchanges(slabel, time, deaths, timeDelta);
        }
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SIN_MODULATE_POPULATION_MODEL;
    }

    @Override
    public double getPhaseShift() {
        return this.phaseShift;
    }

    @Override
    public void setPhaseShift(double newPhaseShift) {
        this.phaseShift = newPhaseShift;
    }

    @Override
    public double getPeriodSin() {
        return this.periodSin;
    }

    @Override
    public void setPeriodSin(double newPeriodSin) {
        this.periodSin = newPeriodSin;
    }

    @Override
    public double getMaxBound() {
        return this.maxBound;
    }

    @Override
    public void setMaxBound(double newMaxBound) {
        this.maxBound = newMaxBound;
    }

    @Override
    public double getMinBound() {
        return this.minBound;
    }

    @Override
    public void setMinBound(double newMinBound) {
        this.minBound = newMinBound;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.getPhaseShift();
            }
            case 19: {
                return this.getPeriodSin();
            }
            case 20: {
                return this.getMaxBound();
            }
            case 21: {
                return this.getMinBound();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.setPhaseShift((Double)newValue);
                return;
            }
            case 19: {
                this.setPeriodSin((Double)newValue);
                return;
            }
            case 20: {
                this.setMaxBound((Double)newValue);
                return;
            }
            case 21: {
                this.setMinBound((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.setPhaseShift(0.0);
                return;
            }
            case 19: {
                this.setPeriodSin(365.25);
                return;
            }
            case 20: {
                this.setMaxBound(1.0);
                return;
            }
            case 21: {
                this.setMinBound(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return this.phaseShift != 0.0;
            }
            case 19: {
                return this.periodSin != 365.25;
            }
            case 20: {
                return this.maxBound != 1.0;
            }
            case 21: {
                return this.minBound != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (phaseShift: ");
        result.append(this.phaseShift);
        result.append(", periodSin: ");
        result.append(this.periodSin);
        result.append(", maxBound: ");
        result.append(this.maxBound);
        result.append(", minBound: ");
        result.append(this.minBound);
        result.append(')');
        return result.toString();
    }
}

