/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.ge.servlet.SlideShowInfo;

public class SlideShowServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static boolean DEBUG = false;
    private static final boolean TEST = false;
    private static final long start = new Date().getTime();
    public static final String CONTEXT = "STEM";
    static final String STEM_FOLDER = "c:\\tmp\\ge";
    private static HashMap<String, SlideShowInfo> _infoMap = null;
    private boolean bboxSet = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        _infoMap = new HashMap();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int counter = 0;
        String fileName = null;
        SlideShowInfo info = null;
        File[] files = null;
        try {
            info = this.getParameters(request);
            String key = info.getKey();
            if (this.bboxSet) {
                this.processNoOp(request, response);
            }
            info.delay();
            fileName = info.getFileName();
            if (fileName != null) {
                this.processFile(request, response, info, fileName);
                return;
            }
            files = info.getFiles();
            if (files == null) {
                files = this.getFiles(info);
            }
            counter = this.getCounter(request, response, info);
            files = info.getFiles();
            if (files.length == 0) {
                if (info.isWaitForKML()) {
                    this.sendScreenOverlay(request, response, "Waiting to Start");
                } else {
                    response.sendError(400, "No KML files in specified folder.");
                }
                return;
            }
            File kmlFile = files[counter];
            SlideShowServlet.debug("Send to GE: " + kmlFile);
            FileInputStream fis = new FileInputStream(kmlFile);
            String[] insert = info.getInsert();
            this.sendOutput(request, response, fis, insert);
            info.setCounter(counter);
            _infoMap.put(key, info);
        }
        catch (Throwable e) {
            e.printStackTrace();
            response.sendError(500, e.getMessage());
        }
    }

    private synchronized int getCounter(HttpServletRequest request, HttpServletResponse response, SlideShowInfo info) throws Exception {
        int counter;
        block5: {
            counter = info.getCounter();
            ++counter;
            int waits = 10;
            int max = info.getFiles().length;
            while (counter >= max) {
                if (info.isWaitForKML()) {
                    Thread.sleep(1000L);
                    info.setFiles(null);
                    this.getFiles(info);
                    max = info.getFiles().length;
                    if (--waits > 0) continue;
                    counter = max - 1;
                    if (!info.isPause()) {
                        info.setPause(true);
                        String host = this.getHost(request);
                        String url = "http://" + host + "/" + CONTEXT + "/image?text=" + URLEncoder.encode("Paused", "UTF-8");
                        String[] insert = this.buildScreenOverlay(url);
                        info.setInsert(insert);
                    }
                } else {
                    SlideShowServlet.debug("Pause 10 seconds before restarting");
                    Thread.sleep(10000L);
                    counter = 0;
                }
                break block5;
            }
            if (info.isPause()) {
                info.setPause(false);
                Thread.sleep(2000L);
                String host = this.getHost(request);
                String url = "http://" + host + "/" + CONTEXT + "/image?text=" + URLEncoder.encode("Active", "UTF-8");
                String[] insert = this.buildScreenOverlay(url);
                info.setInsert(insert);
            }
        }
        return counter;
    }

    private void processNoOp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            PrintWriter os = new PrintWriter((OutputStream)response.getOutputStream());
            response.setContentType("application/keyhole");
            os.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            os.println("<kml xmlns=\"http://earth.google.com/kml/2.0\">");
            os.println("<Document>");
            os.println("</Document>");
            os.println("</kml>");
            os.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
            response.sendError(500, e.getMessage());
        }
    }

    private void processFile(HttpServletRequest request, HttpServletResponse response, SlideShowInfo info, String fileName) throws ServletException, IOException {
        try {
            File kmlFile = new File(fileName);
            String oldFileName = fileName.replace("_Current", "_Old");
            File oldFile = new File(oldFileName);
            String[] insert = info.getInsert();
            FileInputStream fis = null;
            int counter = 0;
            try {
                while (!kmlFile.exists()) {
                    Thread.sleep(2000L);
                    if (++counter <= 10) continue;
                    this.rename(oldFile, kmlFile);
                }
                fis = new FileInputStream(kmlFile);
            }
            catch (Exception e) {
                SlideShowServlet.error("processFile failed", e);
                return;
            }
            SlideShowServlet.debug("Send to GE: " + kmlFile);
            this.sendOutput(request, response, fis, insert);
            this.rename(kmlFile, oldFile);
        }
        catch (Throwable e) {
            e.printStackTrace();
            response.sendError(500, e.getMessage());
        }
    }

    private boolean rename(File oldFile, File newFile) {
        try {
            if (newFile.exists()) {
                newFile.delete();
            }
            oldFile.renameTo(newFile);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }

    private String getHost(HttpServletRequest request) {
        int port = request.getServerPort();
        String host = String.valueOf(request.getServerName()) + ":" + port;
        return host;
    }

    public File[] getFiles(SlideShowInfo info) {
        File[] files = null;
        File folder = null;
        try {
            files = info.getFiles();
            if (files == null || files.length == 0) {
                folder = new File(info.getFolderName());
                files = this.fileList(folder);
                if (files == null) {
                    files = new File[]{};
                }
                info.setFiles(files);
            }
        }
        catch (RuntimeException e) {
            SlideShowServlet.error("getFiles() failed. ", e);
            files = new File[]{};
        }
        return files;
    }

    private File[] fileList(File folder) {
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.getName().toLowerCase().startsWith("net")) {
                    return false;
                }
                return f.getName().toLowerCase().endsWith(".kml");
            }
        };
        Comparator<File> compare = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                File f1 = o1;
                File f2 = o2;
                int answer = f1.getName().compareTo(f2.getName());
                return answer;
            }
        };
        try {
            File[] files = folder.listFiles(ff);
            if (files == null) {
                return new File[0];
            }
            Arrays.sort(files, 0, files.length, compare);
            return files;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SlideShowInfo getParameters(HttpServletRequest request) {
        String mykey = "DEFAULT";
        String folderName = STEM_FOLDER;
        boolean waitForKML = false;
        String fileName = null;
        String delay = "2";
        String bbox = null;
        this.bboxSet = false;
        Enumeration e = request.getParameterNames();
        StringBuffer sb = new StringBuffer();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getParameter(name);
            sb.append(String.valueOf(name) + ": " + value + " ");
            if (name.equals("id")) {
                mykey = value;
                continue;
            }
            if (name.equals("folder")) {
                folderName = value;
                continue;
            }
            if (name.equals("delay")) {
                delay = value;
                continue;
            }
            if (name.equals("wait")) {
                if (!value.equals("y")) continue;
                waitForKML = true;
                continue;
            }
            if (name.equals("file")) {
                fileName = value;
                continue;
            }
            if (name.equals("BBOX")) {
                bbox = value;
                continue;
            }
            if (!name.equals("bboxSet")) continue;
            this.bboxSet = true;
        }
        SlideShowInfo info = _infoMap.get(mykey);
        if (info == null) {
            info = new SlideShowInfo(mykey, folderName, waitForKML, fileName, delay);
        }
        if (bbox != null) {
            info.setBBOX(bbox);
        }
        _infoMap.put(mykey, info);
        return info;
    }

    private synchronized void sendOutput(HttpServletRequest request, HttpServletResponse response, InputStream kml, String[] insert) throws IOException {
        response.setContentType("application/keyhole");
        try {
            ServletOutputStream os = response.getOutputStream();
            this.copy(kml, (OutputStream)os, insert);
        }
        catch (Exception e) {
            String msg = "SlideShowServlet.sendOutput() failed while sending kmlFile";
            SlideShowServlet.error(String.valueOf(msg) + "\n" + e.getMessage(), null);
        }
    }

    private String[] buildScreenOverlay(String url) {
        String[] insert = new String[]{"<ScreenOverlay id=\"Status\">", "   <description>STEM status</description>", "   <name>Status</name>\n", "<icon>", "<href>", url, "</href>", "</icon>\n", "<overlayXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>\n", "<screenXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>\n", "<size x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n", "</ScreenOverlay>\n"};
        return insert;
    }

    private void sendScreenOverlay(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        response.setContentType("application/keyhole");
        try {
            String host = this.getHost(request);
            String url = "http://" + host + "/" + CONTEXT + "/image?text=" + URLEncoder.encode(msg, "UTF-8");
            String[] insert = this.buildScreenOverlay(url);
            PrintWriter os = new PrintWriter((OutputStream)response.getOutputStream());
            response.setContentType("application/keyhole");
            os.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            os.println("<kml xmlns=\"http://earth.google.com/kml/2.0\">");
            os.println("<Document>");
            int i = 0;
            while (i < insert.length) {
                os.println(insert[i]);
                ++i;
            }
            os.println("</Document>");
            os.println("</kml>");
            os.flush();
        }
        catch (Exception e) {
            String emsg = "SlideShowServlet.sendScreenOverlay() failed while writing kmlFile";
            SlideShowServlet.error(String.valueOf(emsg) + "\n" + e.getMessage(), null);
        }
    }

    private static String getClock() {
        long now = new Date().getTime() - start;
        return Long.toString(now);
    }

    public static SlideShowInfo getInfo(String key) {
        SlideShowInfo info = _infoMap.get(key);
        return info;
    }

    private void copy(InputStream is, OutputStream os, String[] insert) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                byte[] buffer = line.getBytes();
                os.write(buffer, 0, buffer.length);
                if (insert == null || !line.toLowerCase().startsWith("<document>")) continue;
                int i = 0;
                while (i < insert.length) {
                    buffer = insert[i].getBytes();
                    os.write(buffer, 0, buffer.length);
                    ++i;
                }
            }
            os.flush();
            os.close();
            is.close();
        }
        catch (Throwable e) {
            SlideShowServlet.error("SlideShowServlet.copy(): Error while copying KML file. " + e.toString(), null);
            try {
                is.close();
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void debug(String msg) {
        if (DEBUG) {
            Activator.logInformation((String)(String.valueOf(SlideShowServlet.getClock()) + " GEServlet: " + msg));
        }
    }

    public static void error(String msg, Throwable e) {
        Activator.logInformation((String)msg);
        if (e != null) {
            if (DEBUG) {
                e.printStackTrace();
            } else {
                Activator.logInformation((String)e.toString());
            }
        }
    }
}

