/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal.datamodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.trace.internal.datamodel.TracingNode;

public abstract class AbstractTracingNode
implements TracingNode {
    protected TracingNode parent = null;
    protected String label = null;
    protected List<TracingNode> children = new ArrayList<TracingNode>();
    private boolean childrenInitialized = false;

    protected abstract void populateChildren();

    public String getLabel() {
        return this.label;
    }

    public TracingNode getParent() {
        return this.parent;
    }

    public TracingNode[] getChildren() {
        this.initialize();
        return this.children.toArray(new TracingNode[this.children.size()]);
    }

    public boolean hasChildren() {
        this.initialize();
        return this.children != null && this.children.size() > 0;
    }

    public void addChild(TracingNode childNode) {
        if (!this.children.contains(childNode)) {
            this.children.add(childNode);
        }
    }

    public void initialize() {
        if (!this.childrenInitialized) {
            this.populateChildren();
            this.childrenInitialized = true;
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setParent(TracingNode parent) {
        if (this.parent == null) {
            this.parent = parent;
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }
    }
}

