/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class HorizontalShift
extends AbstractLayoutAlgorithm {
    private static final double DELTA = 10.0;
    private static final double VSPACING = 2.0;

    public HorizontalShift(int styles) {
        super(styles);
    }

    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        ArrayList row = new ArrayList();
        int i = 0;
        while (i < entitiesToLayout.length) {
            this.addToRowList(entitiesToLayout[i], row);
            ++i;
        }
        int heightSoFar = 0;
        Collections.sort(row, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                List a0 = (List)arg0;
                List a1 = (List)arg1;
                LayoutEntity node0 = ((InternalNode)a0.get(0)).getLayoutEntity();
                LayoutEntity node1 = ((InternalNode)a1.get(0)).getLayoutEntity();
                return (int)(node0.getYInLayout() - node1.getYInLayout());
            }
        });
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            List currentRow = (List)iterator.next();
            Collections.sort(currentRow, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return (int)(((InternalNode)arg1).getLayoutEntity().getYInLayout() - ((InternalNode)arg0).getLayoutEntity().getYInLayout());
                }
            });
            Iterator iterator2 = currentRow.iterator();
            int i2 = 0;
            int width = (int)(boundsWidth / 2.0 - (double)(currentRow.size() * 75));
            heightSoFar = (int)((double)heightSoFar + (((InternalNode)currentRow.get(0)).getLayoutEntity().getHeightInLayout() + 16.0));
            while (iterator2.hasNext()) {
                InternalNode currentNode = (InternalNode)iterator2.next();
                double location = width + 10 * ++i2;
                currentNode.setLocation(location, heightSoFar);
                width = (int)((double)width + currentNode.getLayoutEntity().getWidthInLayout());
            }
        }
    }

    private void addToRowList(InternalNode node, ArrayList list) {
        double layoutY = node.getLayoutEntity().getYInLayout();
        int i = 0;
        while (i < list.size()) {
            List currentRow = (List)list.get(i);
            InternalNode currentRowNode = (InternalNode)currentRow.get(0);
            double currentRowY = currentRowNode.getLayoutEntity().getYInLayout();
            if (layoutY >= currentRowY - 10.0 && layoutY <= currentRowY + 10.0) {
                currentRow.add(node);
                return;
            }
            ++i;
        }
        ArrayList<InternalNode> newRow = new ArrayList<InternalNode>();
        newRow.add(node);
        list.add(newRow);
    }

    protected int getCurrentLayoutStep() {
        return 0;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return 0;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
        return true;
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
    }

    public void setLayoutArea(double x, double y, double width, double height) {
    }
}

