/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.index.IndexLocation;

public class FileIndexLocation
extends IndexLocation {
    File indexFile;

    public FileIndexLocation(File file) {
        super(file);
        this.indexFile = file;
    }

    public FileIndexLocation(URL url, File file) {
        super(url);
        this.indexFile = file;
    }

    public FileIndexLocation(File file, boolean participantIndex) {
        this(file);
        this.participantIndex = true;
    }

    public boolean createNewFile() throws IOException {
        return this.indexFile.createNewFile();
    }

    public boolean delete() {
        return this.indexFile.delete();
    }

    public boolean equals(Object other) {
        if (!(other instanceof FileIndexLocation)) {
            return false;
        }
        return this.indexFile.equals(((FileIndexLocation)other).indexFile);
    }

    public boolean exists() {
        return this.indexFile.exists();
    }

    public String fileName() {
        return this.indexFile.getName();
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    InputStream getInputStream() throws IOException {
        return new FileInputStream(this.indexFile);
    }

    public String getCanonicalFilePath() {
        try {
            return this.indexFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        return this.indexFile.hashCode();
    }

    public long lastModified() {
        return this.indexFile.lastModified();
    }

    public long length() {
        return this.indexFile.length();
    }

    public boolean startsWith(IPath path) {
        try {
            return path.isPrefixOf((IPath)new Path(this.indexFile.getCanonicalPath()));
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

