/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;

public class CompartmentSetConstraintCommand
extends Command {
    private Rectangle newBounds;
    private Rectangle oldBounds;
    private ChangeBoundsRequest request;
    private CompartmentElement compartment;

    public CompartmentSetConstraintCommand(CompartmentElement compartment, ChangeBoundsRequest request, Rectangle newBounds) {
        this.compartment = compartment;
        this.request = request;
        this.newBounds = newBounds.getCopy();
        this.setLabel("move / resize");
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.compartment.getX(), this.compartment.getY(), this.compartment.getWidth(), this.compartment.getHeight());
        this.redo();
    }

    public void redo() {
        this.compartment.setX(this.newBounds.x());
        this.compartment.setY(this.newBounds.y());
        this.compartment.setWidth(this.newBounds.width());
        this.compartment.setHeight(this.newBounds.height());
    }

    public void undo() {
        this.compartment.setX(this.oldBounds.x());
        this.compartment.setY(this.oldBounds.y());
        this.compartment.setWidth(this.oldBounds.width());
        this.compartment.setHeight(this.oldBounds.height());
    }
}

