/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction.presentation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.foodproduction.FoodTransformer;
import org.eclipse.stem.foodproduction.presentation.FoodProductionMessages;
import org.eclipse.stem.foodproduction.presentation.FoodProductionPropertyEditor;
import org.eclipse.stem.foodproduction.presentation.StandardFoodProductionPropertyEditor;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.foodproduction.adapters.FoodProductionPropertyEditorAdapter;
import org.eclipse.stem.ui.foodproduction.adapters.FoodProductionPropertyEditorAdapterFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FoodProductionPropertyComposite
extends Composite {
    private Map<FoodTransformer, FoodProductionPropertyEditor> modelMap = new HashMap<FoodTransformer, FoodProductionPropertyEditor>();
    private StackLayout stackLayout = new StackLayout();

    public FoodProductionPropertyComposite(Composite parent, int style, FoodTransformer[] foodTransformers, ModifyListener projectValidator, IProject project) {
        super(parent, style);
        this.setLayout((Layout)this.stackLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(FoodProductionMessages.getString("FPPC1"));
        FoodProductionPropertyEditor firstOne = null;
        if (foodTransformers != null) {
            FoodTransformer[] foodTransformerArray = foodTransformers;
            int n = foodTransformers.length;
            int n2 = 0;
            while (n2 < n) {
                FoodTransformer model = foodTransformerArray[n2];
                FoodProductionPropertyEditorAdapter fppea = (FoodProductionPropertyEditorAdapter)FoodProductionPropertyEditorAdapterFactory.INSTANCE.adapt((Notifier)model, FoodProductionPropertyEditorAdapter.class);
                FoodProductionPropertyEditor fppe = fppea.createFoodProductionPropertyEditor(this, 0, projectValidator, project);
                this.modelMap.put(model, fppe);
                if (firstOne == null) {
                    firstOne = fppe;
                }
                ++n2;
            }
        }
        this.stackLayout.topControl = firstOne;
    }

    void displayFoodTransformer(FoodTransformer foodTransformer) {
        FoodProductionPropertyEditor fppe = this.modelMap.get(foodTransformer);
        if (fppe != null) {
            this.stackLayout.topControl = fppe;
            this.layout();
        } else {
            Activator.logError((String)(String.valueOf(FoodProductionMessages.getString("FPPC2")) + foodTransformer.getClass().getName() + "\""), null);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return ((StandardFoodProductionPropertyEditor)this.stackLayout.topControl).validate();
    }

    public String getErrorMessage() {
        return ((StandardFoodProductionPropertyEditor)this.stackLayout.topControl).getErrorMessage();
    }

    public void populateFoodTransformer(FoodTransformer foodTransformer) {
        ((StandardFoodProductionPropertyEditor)this.stackLayout.topControl).populate(foodTransformer);
    }
}

