/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;

public class NodeImpl
extends IdentifiableImpl
implements Node {
    protected EList<Edge> edges;
    protected EList<NodeLabel> labels;

    protected NodeImpl() {
        this.setTypeURI(STEMURI.NODE_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return GraphPackage.Literals.NODE;
    }

    @Override
    public EList<Edge> getEdges() {
        if (this.edges == null) {
            this.edges = new EObjectResolvingEList(Edge.class, (InternalEObject)this, 3);
        }
        return this.edges;
    }

    @Override
    public EList<NodeLabel> getLabels() {
        if (this.labels == null) {
            this.labels = new EObjectWithInverseResolvingEList(NodeLabel.class, (InternalEObject)this, 4, 6);
        }
        return this.labels;
    }

    @Override
    public Label getLabel(EClass class_, EAttribute attribute, Object attributeValue) {
        for (Label l : this.getLabels()) {
            if (!class_.isSuperTypeOf(l.eClass()) || !l.eGet((EStructuralFeature)attribute).equals(attributeValue)) continue;
            return l;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getLabels()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getLabels()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        if (this.getLabels() != null) {
            Iterator labelIter = this.getLabels().iterator();
            while (labelIter.hasNext() && retValue) {
                NodeLabel nodeLabel = (NodeLabel)labelIter.next();
                boolean bl = retValue = retValue && nodeLabel.getURIOfIdentifiableToBeLabeled().equals(this.getURI());
                assert (retValue);
            }
        }
        return retValue;
    }

    @Override
    public String toString() {
        String title = this.getDublinCore().getTitle();
        return title != null ? title : super.toString();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getEdges();
            }
            case 4: {
                return this.getLabels();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getEdges().clear();
                this.getEdges().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getLabels().clear();
                this.getLabels().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getEdges().clear();
                return;
            }
            case 4: {
                this.getLabels().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.edges != null && !this.edges.isEmpty();
            }
            case 4: {
                return this.labels != null && !this.labels.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

