/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.loggers.AsynchronousLogger;
import org.eclipse.stem.loggers.LOGGER_EVENTS;
import org.eclipse.stem.loggers.SimulationLogger;
import org.eclipse.stem.loggers.manager.ISimulationLoggerManagerListener;
import org.eclipse.stem.loggers.manager.LoggerAdapter;

public class SimulationLoggerManager
implements ISimulationManagerListenerSync {
    private static SimulationLoggerManager INSTANCE;
    private final Map<ISimulation, List<LoggerAdapter>> loggers = new HashMap<ISimulation, List<LoggerAdapter>>();
    private final List<ISimulationLoggerManagerListener> listeners = new CopyOnWriteArrayList<ISimulationLoggerManagerListener>();
    private final List<SimulationLogger> autoAddedLoggers = new CopyOnWriteArrayList<SimulationLogger>();
    private final SimulationManager simulationManager = SimulationManager.getManager();

    public static synchronized SimulationLoggerManager getManager() {
        if (INSTANCE == null) {
            INSTANCE = new SimulationLoggerManager();
        }
        return INSTANCE;
    }

    public Collection<ISimulation> getActiveSimulations() {
        return Collections.unmodifiableCollection(this.loggers.keySet());
    }

    public void addAutoAddedLogger(SimulationLogger logger) {
        this.autoAddedLoggers.add(logger);
    }

    public void removeAutoAddedLogger(SimulationLogger logger) {
        this.autoAddedLoggers.remove(logger);
    }

    private SimulationLoggerManager() {
        this.startup();
    }

    void startup() {
        this.simulationManager.addSimulationManagerListenerSync((ISimulationManagerListenerSync)this);
        this.fireListenerEvent(LOGGER_EVENTS.LOGGER_MANAGER_STARTED, null);
    }

    public Collection<SimulationLogger> getLoggersForSimulation(ISimulation simulation) {
        if (simulation == null) {
            return null;
        }
        List<LoggerAdapter> adapters = this.loggers.get(simulation);
        ArrayList<SimulationLogger> loggers2 = new ArrayList<SimulationLogger>();
        if (adapters != null) {
            for (LoggerAdapter adapter : adapters) {
                loggers2.add(adapter.getLogger());
            }
        }
        return Collections.unmodifiableCollection(loggers2);
    }

    public void addListener(ISimulationLoggerManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ISimulationLoggerManagerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireListenerEvent(LOGGER_EVENTS event, Object[] targets) {
        for (ISimulationLoggerManagerListener listener : this.listeners) {
            listener.simulationLoggerEvent(event, targets);
        }
    }

    public void shutdown() {
        LinkedList<ISimulation> tempList = new LinkedList<ISimulation>();
        tempList.addAll(this.loggers.keySet());
        for (ISimulation simulation : tempList) {
            this.handleRemovedSimulation(simulation);
        }
        tempList.clear();
        this.fireListenerEvent(LOGGER_EVENTS.LOGGER_MANAGER_STOPPED, null);
        this.listeners.clear();
    }

    public void simulationsChangedSync(SimulationManagerEvent event) {
        ISimulation[] iSimulationArray = event.getSimulationsRemoved();
        int n = iSimulationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISimulation removedSimulation = iSimulationArray[n2];
            this.handleRemovedSimulation(removedSimulation);
            ++n2;
        }
        if (event.getSimulationsRemoved().length > 0) {
            this.fireListenerEvent(LOGGER_EVENTS.SIMULATIONS_REMOVED, event.getSimulationsRemoved());
        }
        iSimulationArray = event.getSimulationsAdded();
        n = iSimulationArray.length;
        n2 = 0;
        while (n2 < n) {
            ISimulation addedSimulation = iSimulationArray[n2];
            this.handleAddedSimulation(addedSimulation);
            ++n2;
        }
        if (event.getSimulationsAdded().length > 0) {
            this.fireListenerEvent(LOGGER_EVENTS.SIMULATIONS_ADDED, event.getSimulationsAdded());
        }
    }

    private LoggerAdapter handleAddedLogger(ISimulation simulation, SimulationLogger logger) {
        LoggerAdapter wrapper = new LoggerAdapter(simulation, (SimulationLogger)EcoreUtil.copy((EObject)logger));
        wrapper.fireLoggerEvent(LOGGER_EVENTS.LOGGER_STARTED);
        if (logger instanceof AsynchronousLogger) {
            simulation.addSimulationListener((ISimulationListener)wrapper, true);
        } else {
            simulation.addSimulationListenerSync((ISimulationListenerSync)wrapper, true);
        }
        return wrapper;
    }

    public void addLoggerToSimulation(ISimulation simulation, SimulationLogger logger) {
        if (simulation != null && logger != null) {
            List<LoggerAdapter> simulationLoggers = this.loggers.get(simulation);
            if (simulationLoggers == null) {
                return;
            }
            LoggerAdapter adapter = this.handleAddedLogger(simulation, logger);
            simulationLoggers.add(adapter);
            this.fireListenerEvent(LOGGER_EVENTS.SIMULATIONS_ADDED, new Object[]{adapter});
        }
    }

    private void handleAddedSimulation(ISimulation simulation) {
        ArrayList<LoggerAdapter> simulationLoggers = new ArrayList<LoggerAdapter>();
        this.loggers.put(simulation, simulationLoggers);
        for (Logger logger : simulation.getScenario().getLoggers()) {
            if (!(logger instanceof SimulationLogger)) continue;
            simulationLoggers.add(this.handleAddedLogger(simulation, (SimulationLogger)logger));
        }
        for (SimulationLogger simulationLogger : this.autoAddedLoggers) {
            simulationLoggers.add(this.handleAddedLogger(simulation, simulationLogger));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemovedSimulation(ISimulation simulation) {
        List<LoggerAdapter> simulationLoggers = this.loggers.get(simulation);
        if (simulationLoggers != null) {
            List<LoggerAdapter> list = simulationLoggers;
            synchronized (list) {
                Iterator<LoggerAdapter> iter = simulationLoggers.iterator();
                while (iter.hasNext()) {
                    LoggerAdapter wrapper = iter.next();
                    simulation.removeSimulationListener((ISimulationListener)wrapper);
                    simulation.removeSimulationListenerSync((ISimulationListenerSync)wrapper);
                    wrapper.fireLoggerEvent(LOGGER_EVENTS.LOGGER_STOPPED);
                    wrapper.destroy();
                    iter.remove();
                }
            }
            this.loggers.remove(simulation);
        }
    }
}

