/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.interventions.presentation;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.graphgenerators.GraphGenerator;
import org.eclipse.stem.interventions.ControlGraphGenerator;
import org.eclipse.stem.interventions.InterventionsPackage;
import org.eclipse.stem.interventions.PeriodicControlGraphGenerator;
import org.eclipse.stem.ui.graphgenerators.adapters.graphgeneratorpropertyeditor.GraphGeneratorPropertyEditor;
import org.eclipse.stem.ui.interventions.nls.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ControlGraphGeneratorPropertyEditor
extends GraphGeneratorPropertyEditor {
    public ControlGraphGeneratorPropertyEditor(Composite parent, int style, IProject project) {
        super(parent, style, project);
    }

    public ControlGraphGeneratorPropertyEditor(Composite parent, int style, GraphGenerator graphGenerator, ModifyListener projectValidator, IProject project) {
        super(parent, style, graphGenerator, projectValidator, project);
    }

    public Graph getGraph(GraphGenerator graphGenerator) {
        for (Map.Entry entry : this.map.entrySet()) {
            if (((EStructuralFeature)entry.getKey()).getEContainingClass().getClassifierID() == 2) {
                switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                    case 4: {
                        ((ControlGraphGenerator)graphGenerator).setIsolationFraction(Double.parseDouble(((Text)entry.getValue()).getText()));
                        break;
                    }
                    case 3: {
                        ((ControlGraphGenerator)graphGenerator).setVaccinationFraction(Double.parseDouble(((Text)entry.getValue()).getText()));
                        break;
                    }
                    case 5: {
                        ((ControlGraphGenerator)graphGenerator).setPopulationIdentifier(((Text)entry.getValue()).getText());
                        break;
                    }
                    case 6: {
                        String txt = ((Text)entry.getValue()).getText();
                        if (txt == null || txt.trim().equals("")) {
                            ((ControlGraphGenerator)graphGenerator).setLocation(null);
                            break;
                        }
                        ((ControlGraphGenerator)graphGenerator).setLocation(STEMURI.createURI((String)((Text)entry.getValue()).getText()));
                    }
                }
                continue;
            }
            if (((EStructuralFeature)entry.getKey()).getEContainingClass().getClassifierID() != 6) continue;
            switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                case 4: {
                    String p = ((Text)entry.getValue()).getText();
                    ((PeriodicControlGraphGenerator)graphGenerator).setDataPath(p);
                    break;
                }
                case 3: {
                    String i = ((Text)entry.getValue()).getText();
                    ((PeriodicControlGraphGenerator)graphGenerator).setPopulationIdentifier(i);
                    break;
                }
                case 5: {
                    String pr = ((Text)entry.getValue()).getText();
                    long period = Long.parseLong(pr);
                    ((PeriodicControlGraphGenerator)graphGenerator).setPeriod(period);
                }
            }
        }
        for (Map.Entry entry : this.booleanMap.entrySet()) {
            if (((EStructuralFeature)entry.getKey()).getEContainingClass().getClassifierID() != 6) continue;
            switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                case 6: {
                    boolean b = ((Button)entry.getValue()).getSelection();
                    ((PeriodicControlGraphGenerator)graphGenerator).setUseVaccinations(b);
                    break;
                }
                case 7: {
                    boolean b1 = ((Button)entry.getValue()).getSelection();
                    ((PeriodicControlGraphGenerator)graphGenerator).setFraction(b1);
                }
            }
        }
        if (graphGenerator.eClass().getClassifierID() == 2) {
            ((ControlGraphGenerator)graphGenerator).setProject(this.project);
        }
        return graphGenerator.getGraph();
    }

    public boolean validate() {
        Text text;
        boolean retValue = true;
        if (retValue && (text = (Text)this.map.get(InterventionsPackage.Literals.CONTROL_GRAPH_GENERATOR__ISOLATION_FRACTION)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("CGGWizErr1");
            } else {
                retValue = this.isValidDoubleValue(text.getText(), 0.0, 1.0);
                if (!retValue) {
                    this.errorMessage = Messages.getString("CGGWizErr2");
                }
            }
        }
        if (retValue && (text = (Text)this.map.get(InterventionsPackage.Literals.CONTROL_GRAPH_GENERATOR__VACCINATION_FRACTION)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("CGGWizErr3");
            } else {
                retValue = this.isValidDoubleValue(text.getText(), 0.0, 1.0);
                if (!retValue) {
                    this.errorMessage = Messages.getString("CGGWizErr4");
                }
            }
        }
        if (retValue && (text = (Text)this.map.get(InterventionsPackage.Literals.CONTROL_GRAPH_GENERATOR__POPULATION_IDENTIFIER)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("CGGWizErr5");
            }
        }
        return retValue;
    }

    protected boolean isUserSpecifiedProperty(EStructuralFeature feature) {
        boolean retValue = false;
        EClass containingClass = feature.getEContainingClass();
        if (containingClass.equals(InterventionsPackage.eINSTANCE.getControlGraphGenerator()) || containingClass.equals(InterventionsPackage.eINSTANCE.getPeriodicControlGraphGenerator()) || containingClass.getEAllSuperTypes().contains((Object)InterventionsPackage.eINSTANCE.getControlGraphGenerator())) {
            retValue = true;
        }
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

