/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class EObjectAtOffsetHelper {
    public EObject resolveElementAt(XtextResource resource, int offset) {
        return this.internalResolveElementAt(resource, offset, false);
    }

    public EObject resolveContainedElementAt(XtextResource resource, int offset) {
        return this.internalResolveElementAt(resource, offset, true);
    }

    public EObject resolveCrossReferencedElementAt(XtextResource resource, int offset) {
        INode node = this.getCrossReferenceNode(resource, (ITextRegion)new TextRegion(offset, 0));
        if (node != null) {
            return this.getCrossReferencedElement(node);
        }
        return null;
    }

    public INode getCrossReferenceNode(XtextResource resource, ITextRegion region) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset(parseResult.getRootNode(), region.getOffset());
            INode crossRefNode = this.findCrossReferenceNode(leaf);
            if (crossRefNode == null && leaf != null && region.getLength() == 0 && leaf.getOffset() == region.getOffset()) {
                leaf = NodeModelUtils.findLeafNodeAtOffset(parseResult.getRootNode(), region.getOffset() - 1);
                return this.findCrossReferenceNode(leaf);
            }
            if (crossRefNode != null && crossRefNode.getEndOffset() >= region.getOffset() + region.getLength()) {
                return crossRefNode;
            }
        }
        return null;
    }

    public EObject getCrossReferencedElement(INode node) {
        if (!(node.getGrammarElement() instanceof CrossReference)) {
            throw new IllegalArgumentException("Passed node not a cross reference node.");
        }
        return this.resolveCrossReferencedElement(node);
    }

    /*
     * Unable to fully structure code
     */
    protected INode findCrossReferenceNode(INode node) {
        if (node == null) {
            return null;
        }
        if (!(node.getGrammarElement() instanceof CrossReference)) ** GOTO lbl7
        return node;
lbl-1000:
        // 1 sources

        {
            if (!((node = node.getParent()).getGrammarElement() instanceof CrossReference)) continue;
            return node;
lbl7:
            // 2 sources

            ** while (node.getGrammarElement() != null && this.isElementOfDatatypeRule((EObject)node.getGrammarElement()))
        }
lbl8:
        // 1 sources

        return null;
    }

    protected boolean isElementOfDatatypeRule(EObject grammarElement) {
        AbstractRule rule = EcoreUtil2.getContainerOfType(grammarElement, AbstractRule.class);
        return GrammarUtil.isDatatypeRule(rule);
    }

    protected EObject internalResolveElementAt(XtextResource resource, int offset, boolean containment) {
        EObject crossRef;
        if (!containment && (crossRef = this.resolveCrossReferencedElementAt(resource, offset)) != null) {
            return crossRef;
        }
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset(parseResult.getRootNode(), offset);
            if (leaf != null && leaf.isHidden() && leaf.getOffset() == offset) {
                leaf = NodeModelUtils.findLeafNodeAtOffset(parseResult.getRootNode(), offset - 1);
            }
            if (leaf != null) {
                return NodeModelUtils.findActualSemanticObjectFor(leaf);
            }
        }
        return null;
    }

    protected EObject resolveCrossReferencedElement(INode node) {
        EObject referenceOwner = NodeModelUtils.findActualSemanticObjectFor(node);
        if (referenceOwner != null) {
            EReference crossReference = GrammarUtil.getReference((CrossReference)node.getGrammarElement(), referenceOwner.eClass());
            if (!crossReference.isMany()) {
                return (EObject)referenceOwner.eGet((EStructuralFeature)crossReference);
            }
            List listValue = (List)referenceOwner.eGet((EStructuralFeature)crossReference);
            List<INode> nodesForFeature = NodeModelUtils.findNodesForFeature(referenceOwner, (EStructuralFeature)crossReference);
            int currentIndex = 0;
            for (INode nodeForFeature : nodesForFeature) {
                if (currentIndex >= listValue.size()) {
                    return null;
                }
                if (nodeForFeature.getTotalOffset() <= node.getTotalOffset() && nodeForFeature.getTotalEndOffset() >= node.getTotalEndOffset()) {
                    return (EObject)listValue.get(currentIndex);
                }
                ++currentIndex;
            }
        }
        return null;
    }
}

