/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.bpmn.validation.IResourceImportersRegistry;
import org.eclipse.stp.bpmn.validation.builder.TransitiveImporters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImportersRegistry
implements IResourceImportersRegistry {
    public ListenerList changeListeners = new ListenerList();
    private static String SEPARATOR = ":";
    private boolean _isDirty;
    private Map<IResource, Set<IResource>> _importsIndexedByImporters = new HashMap<IResource, Set<IResource>>();
    private Map<IResource, Set<IResource>> _importersIndexedByImports = new HashMap<IResource, Set<IResource>>();

    @Override
    public Set<IResource> getImports(IResource importer) {
        return this._importsIndexedByImporters.get(importer);
    }

    @Override
    public Set<IResource> getImporters(IResource imported) {
        return this._importersIndexedByImports.get(imported);
    }

    @Override
    public void addImport(IResource importer, IResource imported) {
        Set<IResource> imports = this._importsIndexedByImporters.get(importer);
        if (imports == null) {
            imports = new HashSet<IResource>();
            this._importsIndexedByImporters.put(importer, imports);
        }
        imports.add(imported);
        Set<IResource> importers = this._importersIndexedByImports.get(imported);
        if (importers == null) {
            importers = new HashSet<IResource>();
            this._importersIndexedByImports.put(imported, importers);
        }
        importers.add(importer);
        this._isDirty = true;
        this.fireImportAdded(importer, imported);
    }

    @Override
    public void clearImports(IResource importer) {
        Set<IResource> imports = this._importsIndexedByImporters.remove(importer);
        if (imports != null) {
            for (IResource imported : imports) {
                Set<IResource> importers = this._importersIndexedByImports.get(imported);
                if (importers == null) continue;
                importers.remove(importer);
            }
        }
        this._isDirty = true;
        this.fireImportsCleared(importer, imports);
    }

    @Override
    public void load(IProject project, String importCategoryID, IProgressMonitor monitor) {
        block16: {
            this.clearAll();
            IFile dagFile = (IFile)project.findMember(this.getStorageLocation(importCategoryID));
            if (dagFile == null) {
                return;
            }
            InputStream contents = null;
            try {
                try {
                    contents = dagFile.getContents();
                    Properties props = new Properties();
                    props.load(contents);
                    for (Map.Entry<Object, Object> kvp : props.entrySet()) {
                        HashSet<IFile> imports = new HashSet<IFile>();
                        String simporter = (String)kvp.getKey();
                        String simports = (String)kvp.getValue();
                        IResource importer = project.findMember((IPath)new Path(simporter));
                        if (importer == null) continue;
                        StringTokenizer tokenizer = new StringTokenizer(simports, String.valueOf(SEPARATOR), false);
                        while (tokenizer.hasMoreTokens()) {
                            Path path = new Path(tokenizer.nextToken());
                            IFile imported = project.getFile((IPath)path);
                            imports.add(imported);
                            Set<IResource> importers = this._importersIndexedByImports.get(imported);
                            if (importers == null) {
                                importers = new HashSet<IResource>();
                                this._importersIndexedByImports.put((IResource)imported, importers);
                            }
                            importers.add(importer);
                        }
                        this._importsIndexedByImporters.put(importer, imports);
                    }
                }
                catch (Throwable throwable) {
                    if (contents == null) break block16;
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void save(IProject project, String importsCategory, IProgressMonitor monitor) throws CoreException {
        Properties props = new Properties();
        for (Map.Entry<IResource, Set<IResource>> entry : this._importsIndexedByImporters.entrySet()) {
            Set<IResource> imports = entry.getValue();
            if (imports.isEmpty()) continue;
            Iterator<IResource> it = imports.iterator();
            IResource r = null;
            StringBuilder buf = null;
            while (r == null && it.hasNext()) {
                r = it.next();
                IPath rPath = r.getProjectRelativePath();
                if (rPath == null) continue;
                buf = new StringBuilder();
                buf.append(r.getProjectRelativePath().toString());
                break;
            }
            if (buf == null) continue;
            while (it.hasNext()) {
                IPath rpath = it.next().getProjectRelativePath();
                if (rpath == null) continue;
                buf.append(String.valueOf(SEPARATOR) + rpath.toString());
            }
            props.put(entry.getKey().getProjectRelativePath().toString(), buf.toString());
        }
        InputStream closeMe = null;
        try {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                props.store(out, "# index of importer -> set(imports)");
                IFile fileHandle = project.getFile(this.getStorageLocation(importsCategory));
                closeMe = new ByteArrayInputStream(out.toByteArray());
                if (!fileHandle.exists()) {
                    if (!fileHandle.getParent().exists() && fileHandle.getParent() instanceof IFolder) {
                        ((IFolder)fileHandle.getParent()).create(true, true, monitor);
                    }
                    fileHandle.create(closeMe, true, monitor);
                } else {
                    fileHandle.setContents(closeMe, true, false, monitor);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.stp.bpmn.validation", 2, "Unable to write ", (Throwable)e));
            }
        }
        finally {
            this._isDirty = false;
            if (closeMe != null) {
                try {
                    closeMe.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected IPath getStorageLocation(String categoryId) {
        return new Path(".settings/" + categoryId + ".properties");
    }

    @Override
    public void clearAll() {
        for (IResource importer : new ArrayList<IResource>(this.getAllImporters())) {
            this.clearImports(importer);
        }
        this._importersIndexedByImports.clear();
        this._importsIndexedByImporters.clear();
        this._isDirty = true;
    }

    @Override
    public boolean isDirty() {
        return this._isDirty;
    }

    private void collectImporters(IResource current, IResourceImportersRegistry.ITransitiveImporters res) {
        if (res.getTransitiveImporters().add(current)) {
            for (IResource r : this.getImporters(current)) {
                this.collectImporters(r, res);
            }
        } else {
            res.getCycleIntroducers().add(current);
        }
    }

    @Override
    public IResourceImportersRegistry.ITransitiveImporters computeTransitiveImporters(IResource imported) {
        TransitiveImporters res = new TransitiveImporters();
        this.collectImporters(imported, res);
        return res;
    }

    @Override
    public Set<IResource> getAllImporters() {
        return this._importsIndexedByImporters.keySet();
    }

    @Override
    public void addListener(IResourceImportersRegistry.IResourceImportersRegistryListener listener) {
        this.changeListeners.add((Object)listener);
    }

    @Override
    public void removeListener(IResourceImportersRegistry.IResourceImportersRegistryListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    protected final void fireImportAdded(IResource importer, IResource imported) {
        Object[] objectArray = this.changeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceImportersRegistry.IResourceImportersRegistryListener resListener;
            Object listener = objectArray[n2];
            if (listener instanceof IResourceImportersRegistry.IResourceImportersRegistryListener && (resListener = (IResourceImportersRegistry.IResourceImportersRegistryListener)listener).matches(importer)) {
                resListener.importAdded(importer, imported);
            }
            ++n2;
        }
    }

    protected final void fireImportsCleared(IResource importer, Set<IResource> imported) {
        Object[] objectArray = this.changeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceImportersRegistry.IResourceImportersRegistryListener resListener;
            Object listener = objectArray[n2];
            if (listener instanceof IResourceImportersRegistry.IResourceImportersRegistryListener && (resListener = (IResourceImportersRegistry.IResourceImportersRegistryListener)listener).matches(importer)) {
                resListener.importsCleared(importer, imported);
            }
            ++n2;
        }
    }
}

