/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.providers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.validation.BpmnValidationMessages;
import org.eclipse.stp.bpmn.validation.BpmnValidationPlugin;
import org.eclipse.stp.bpmn.validation.IConstraintStatusEx;
import org.eclipse.stp.bpmn.validation.IValidationMarkerCreationHook;
import org.eclipse.stp.bpmn.validation.builder.ValidationMarkerCustomAttributes;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class BpmnValidationProvider
extends AbstractContributionItemProvider {
    public static final String MARKER_TYPE = "org.eclipse.stp.bpmn.validation.diagnostic";
    public static final String MARKER_TASK_TYPE = "org.eclipse.stp.bpmn.diagram.taskmarker";
    private static boolean constraintsActive = false;
    private static GMFResourceFactory RESOURCE_FACTORY = new GMFResourceFactory();

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    protected IAction createAction(String actionId, IWorkbenchPartDescriptor partDescriptor) {
        if ("validateAction".equals(actionId)) {
            return new ValidateAction(partDescriptor);
        }
        return super.createAction(actionId, partDescriptor);
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (BpmnValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && object instanceof Diagram && ((Diagram)object).getElement() instanceof BpmnDiagram;
        }
        return true;
    }

    public static final void validateDiagramFile(IFile diagramFile, IProgressMonitor monitor) throws IOException {
        GMFResource bpmnResource = (GMFResource)RESOURCE_FACTORY.createResource(URI.createURI((String)diagramFile.getFullPath().toPortableString()));
        bpmnResource.load(bpmnResource.getDefaultLoadOptions());
        EList selectedEObjects = bpmnResource.getContents();
        for (EObject eobj : selectedEObjects) {
            if (!(eobj instanceof Diagram)) continue;
            final Diagram diagram = (Diagram)eobj;
            try {
                new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                        ValidateAction.runValidation((View)diagram);
                    }
                }).run(monitor);
            }
            catch (Exception e) {
                BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", 4, BpmnValidationMessages.BpmnValidationProvider_ValidationActionFailed, (Throwable)e));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidateAction
    extends Action {
        public static final String VALIDATE_ACTION_KEY = "validateAction";
        private IWorkbenchPartDescriptor workbenchPartDescriptor;

        public ValidateAction(IWorkbenchPartDescriptor workbenchPartDescriptor) {
            this.setId(VALIDATE_ACTION_KEY);
            this.setText(BpmnValidationMessages.BpmnValidationProvider_validate);
            this.workbenchPartDescriptor = workbenchPartDescriptor;
        }

        public void run() {
            IWorkbenchPart workbenchPart = this.workbenchPartDescriptor.getPartPage().getActivePart();
            if (workbenchPart instanceof IDiagramWorkbenchPart) {
                final IDiagramWorkbenchPart part = (IDiagramWorkbenchPart)workbenchPart;
                try {
                    new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                            ValidateAction.runValidation((View)part.getDiagram());
                        }
                    }).run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", 4, BpmnValidationMessages.BpmnValidationProvider_validateActionFailed, (Throwable)e));
                }
            }
        }

        public static void runValidation(View view) {
            final View target = view;
            Runnable task = new Runnable(){

                public void run() {
                    try {
                        try {
                            constraintsActive = true;
                            ValidateAction.validate(target);
                        }
                        catch (Throwable t) {
                            BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", 4, t.getMessage(), t));
                            constraintsActive = false;
                        }
                    }
                    finally {
                        constraintsActive = false;
                    }
                }
            };
            TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)target);
            if (txDomain != null) {
                try {
                    txDomain.runExclusive(task);
                }
                catch (Exception e) {
                    BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", 4, BpmnValidationMessages.BpmnValidationProvider_validateActionFailed, (Throwable)e));
                }
            } else {
                task.run();
            }
        }

        private static Diagnostic runEMFValidator(View target) {
            if (target.isSetElement() && target.getElement() != null) {
                return new Diagnostician(){

                    public String getObjectLabel(EObject eObject) {
                        try {
                            return EMFCoreUtil.getQualifiedName((EObject)eObject, (boolean)true);
                        }
                        catch (Exception e) {
                            return "<" + eObject.eClass().getName() + ">";
                        }
                    }
                }.validate(target.getElement());
            }
            return Diagnostic.OK_INSTANCE;
        }

        private static void validate(View target) {
            IFile diagramFile = target.eResource() != null ? WorkspaceSynchronizer.getFile((Resource)target.eResource()) : null;
            try {
                if (diagramFile != null) {
                    diagramFile.deleteMarkers(BpmnValidationProvider.MARKER_TYPE, false, 0);
                }
                diagramFile.deleteMarkers(BpmnValidationProvider.MARKER_TASK_TYPE, false, 0);
            }
            catch (CoreException e) {
                BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", 4, BpmnValidationMessages.BpmnValidationProvider_validateFailed, (Throwable)e));
            }
            TreeIterator iter = target.eResource().getAllContents();
            while (iter.hasNext()) {
                String name;
                EObject eobj = (EObject)iter.next();
                if (!(eobj instanceof View)) continue;
                String id = ((View)eobj).getType();
                if (!BpmnVisualIDRegistry.getType((int)2004).equals(id) && !BpmnVisualIDRegistry.getType((int)1002).equals(id) || !(((View)eobj).getElement() instanceof TextAnnotation) || (name = ((TextAnnotation)((View)eobj).getElement()).getName()) == null) continue;
                int taskPriority = -1;
                if (name.indexOf("TODO") != -1 || name.indexOf("XXX") != -1) {
                    taskPriority = 1;
                } else if (name.indexOf("FIXME") != -1) {
                    taskPriority = 2;
                }
                if (taskPriority == -1) continue;
                try {
                    IMarker marker = diagramFile.createMarker(BpmnValidationProvider.MARKER_TASK_TYPE);
                    String location = EMFCoreUtil.getQualifiedName((EObject)eobj, (boolean)true);
                    if (location.startsWith("<Diagram>::")) {
                        location = location.substring("<Diagram>::".length());
                    }
                    marker.setAttribute("location", (Object)location);
                    marker.setAttribute("elementId", (Object)ViewUtil.getIdStr((View)((View)eobj)));
                    marker.setAttribute("message", (Object)name.trim());
                    marker.setAttribute("priority", taskPriority);
                    marker.setAttribute("userEditable", false);
                    Collection<IValidationMarkerCreationHook> hooks = BpmnValidationPlugin.getDefault().getCreationMarkerCallBacks();
                    if (hooks == null) continue;
                    for (IValidationMarkerCreationHook iValidationMarkerCreationHook : hooks) {
                        iValidationMarkerCreationHook.validationMarkerCreated(marker, eobj);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            Diagnostic diagnostic = ValidateAction.runEMFValidator(target);
            IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
            validator.setIncludeLiveConstraints(true);
            IStatus status = Status.OK_STATUS;
            if (target.isSetElement() && target.getElement() != null) {
                status = validator.validate(target.getElement());
            }
            ArrayList<Object> allStatuses = new ArrayList<Object>();
            if (status.isMultiStatus()) {
                if (status instanceof IConstraintStatusEx) {
                    allStatuses.add(status);
                } else {
                    IStatus[] iStatusArray = status.getChildren();
                    int hooks = iStatusArray.length;
                    int location = 0;
                    while (location < hooks) {
                        IStatus st = iStatusArray[location];
                        allStatuses.add(st);
                        ++location;
                    }
                }
            } else {
                allStatuses.add(status);
            }
            HashSet<EObject> targets = new HashSet<EObject>();
            Iterator it = diagnostic.getChildren().iterator();
            while (it.hasNext()) {
                targets.add(ValidateAction.getDiagnosticTarget((Diagnostic)it.next()));
            }
            ArrayList<IConstraintStatus> moreStatuses = new ArrayList<IConstraintStatus>();
            for (IStatus iStatus : allStatuses) {
                if (!(iStatus instanceof IConstraintStatus)) continue;
                targets.add(((IConstraintStatus)iStatus).getTarget());
                if (!((IConstraintStatus)iStatus).isMultiStatus()) continue;
                IStatus[] iStatusArray = ((IConstraintStatus)iStatus).getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus iStatus2 = iStatusArray[n2];
                    if (iStatus2 instanceof IConstraintStatus) {
                        targets.add(((IConstraintStatus)iStatus2).getTarget());
                        moreStatuses.add((IConstraintStatus)iStatus2);
                    }
                    ++n2;
                }
            }
            allStatuses.addAll(moreStatuses);
            Map viewMap = ValidateAction.buildElement2ViewMap(target, targets);
            for (Diagnostic diagnostic2 : diagnostic.getChildren()) {
                List data = diagnostic2.getData();
                if (data.isEmpty() || !(data.get(0) instanceof EObject)) continue;
                EObject element = (EObject)data.get(0);
                View view = ValidateAction.findTargetView(element, viewMap);
                if (diagramFile == null) continue;
                ValidateAction.addMarker(diagramFile, view != null ? view : target, element, diagnostic2.getMessage(), ValidateAction.diagnosticToStatusSeverity(diagnostic2.getSeverity()), diagnostic2.getCode(), ValidateAction.getCustomMarkerAttributes(diagnostic2));
            }
            for (Object e : allStatuses) {
                if (!(e instanceof IConstraintStatus)) continue;
                IConstraintStatus nextStatus = (IConstraintStatus)e;
                View view = ValidateAction.findTargetView(nextStatus.getTarget(), viewMap);
                if (diagramFile == null) continue;
                ValidateAction.addMarker(diagramFile, view != null ? view : target, nextStatus.getTarget(), nextStatus.getMessage(), nextStatus.getSeverity(), nextStatus.getCode(), ValidateAction.getCustomMarkerAttributes(nextStatus));
            }
        }

        private static View findTargetView(EObject targetElement, Map viewMap) {
            if (targetElement instanceof View) {
                return (View)targetElement;
            }
            EObject container = targetElement;
            while (container != null) {
                if (viewMap.containsKey(container)) {
                    return (View)viewMap.get(container);
                }
                container = container.eContainer();
            }
            return null;
        }

        private static Map buildElement2ViewMap(View view, Set targets) {
            HashMap map = new HashMap();
            ValidateAction.getElement2ViewMap(view, map, targets);
            if (!targets.isEmpty()) {
                HashSet<EObject> path = new HashSet<EObject>();
                block0: for (EObject nextNotMapped : targets) {
                    EObject container = nextNotMapped.eContainer();
                    while (container != null) {
                        if (map.containsKey(container)) continue block0;
                        path.add(container);
                        container = container.eContainer();
                    }
                }
                ValidateAction.getElement2ViewMap(view, map, path);
            }
            return map;
        }

        private static void getElement2ViewMap(View view, Map map, Set targets) {
            if (!map.containsKey(view.getElement()) && targets.remove(view.getElement())) {
                map.put(view.getElement(), view);
            }
            Iterator it = view.getChildren().iterator();
            while (it.hasNext()) {
                ValidateAction.getElement2ViewMap((View)it.next(), map, targets);
            }
            if (view instanceof Diagram) {
                it = ((Diagram)view).getEdges().iterator();
                while (it.hasNext()) {
                    ValidateAction.getElement2ViewMap((View)it.next(), map, targets);
                }
            }
        }

        private static Map<String, Object> getCustomMarkerAttributes(Diagnostic diagnostic) {
            return ValidationMarkerCustomAttributes.getMarkerAttributesMap(diagnostic);
        }

        private static Map<String, Object> getCustomMarkerAttributes(IConstraintStatus constrainStatus) {
            return constrainStatus instanceof IConstraintStatusEx ? ((IConstraintStatusEx)constrainStatus).getMarkerCustomAttributes() : null;
        }

        private static void addMarker(IFile file, View view, EObject element, String message, int statusSeverity, int code, Map<String, Object> customAttributes) {
            try {
                IMarker marker = file.createMarker(BpmnValidationProvider.MARKER_TYPE);
                if (customAttributes == null) {
                    customAttributes = new HashMap<String, Object>();
                }
                customAttributes.put("message", message);
                String location = EMFCoreUtil.getQualifiedName((EObject)element, (boolean)true);
                if (location.startsWith("<Diagram>::")) {
                    location = location.substring("<Diagram>::".length());
                }
                customAttributes.put("location", location);
                customAttributes.put("elementId", ViewUtil.getIdStr((View)view));
                int markerSeverity = 0;
                if (statusSeverity == 2) {
                    markerSeverity = 1;
                } else if (statusSeverity == 4 || statusSeverity == 8) {
                    markerSeverity = 2;
                }
                customAttributes.put("severity", markerSeverity);
                customAttributes.put("code", code);
                marker.setAttributes(customAttributes);
                Collection<IValidationMarkerCreationHook> hooks = BpmnValidationPlugin.getDefault().getCreationMarkerCallBacks();
                if (hooks != null) {
                    for (IValidationMarkerCreationHook hook : hooks) {
                        hook.validationMarkerCreated(marker, element);
                    }
                }
            }
            catch (CoreException e) {
                BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", 4, BpmnValidationMessages.BpmnValidationProvider_markerCreationFailed, (Throwable)e));
            }
        }

        private static EObject getDiagnosticTarget(Diagnostic diagnostic) {
            if (!diagnostic.getData().isEmpty()) {
                Object target = diagnostic.getData().get(0);
                return target instanceof EObject ? (EObject)target : null;
            }
            return null;
        }

        private static int diagnosticToStatusSeverity(int diagnosticSeverity) {
            if (diagnosticSeverity == 0) {
                return 0;
            }
            if (diagnosticSeverity == 1) {
                return 1;
            }
            if (diagnosticSeverity == 2) {
                return 2;
            }
            if (diagnosticSeverity == 4 || diagnosticSeverity == 8) {
                return 4;
            }
            return 1;
        }
    }
}

