/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class DataObjectFigure
extends RectangleFigure {
    private int _foldSize;

    public DataObjectFigure(int foldSize) {
        if (this._foldSize < 0) {
            this._foldSize = 16;
        }
        this._foldSize = foldSize;
    }

    protected void dopaint(Graphics graphics, boolean isOutline) {
        graphics.setForegroundColor(ColorConstants.black);
        Rectangle r = this.getBounds();
        int x = r.x + this.lineWidth / 2;
        int y = r.y + this.lineWidth / 2;
        int w = r.width - Math.max(1, this.lineWidth);
        int h = r.height - Math.max(1, this.lineWidth);
        int d = Math.min(w / 2, h / 2);
        d = Math.min(this._foldSize, d);
        Point p1 = new Point(x, y);
        Point p2 = new Point(x, y + h);
        Point p3 = new Point(x + w, p2.y);
        Point p4 = new Point(x + w, y);
        p4.y += d;
        Point p5 = new Point(p4.x - d, p4.y);
        Point p6 = new Point(p5.x, p1.y);
        PointList pl = new PointList();
        pl.addPoint(p1);
        pl.addPoint(p2);
        pl.addPoint(p3);
        pl.addPoint(p4);
        if (isOutline) {
            pl.addPoint(p5);
        }
        pl.addPoint(p6);
        if (isOutline) {
            pl.addPoint(p1);
        }
        if (isOutline) {
            graphics.drawPolyline(pl);
            graphics.drawLine(p6, p4);
        } else {
            graphics.fillPolygon(pl);
        }
    }

    protected void fillShape(Graphics graphics) {
        this.dopaint(graphics, false);
    }

    protected void outlineShape(Graphics graphics) {
        this.dopaint(graphics, true);
    }

    public int getFoldSize() {
        return this._foldSize;
    }
}

