/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.lang.reflect.Field;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.Group2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.GroupEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.policies.PopupBarEditPolicyEx;
import org.eclipse.stp.bpmn.tools.MultipleShapesMoveTool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;

public class SelectionToolEx
extends SelectionTool {
    private static Field toolClassField;
    private boolean spacePressed;

    private static void init() {
        if (toolClassField != null) {
            return;
        }
        try {
            toolClassField = ToolEntry.class.getDeclaredField("toolClass");
            toolClassField.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static void setToolClass(ToolEntry toolEntry, Class toolClass) {
        SelectionToolEx.init();
        try {
            toolClassField.set(toolEntry, toolClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean handleDoubleClick(int button) {
        EditPartViewer viewer;
        if (this.isHoverActive()) {
            this.handleHoverStop();
            this.setHoverActive(false);
        }
        if ((viewer = this.getCurrentViewer()) instanceof GraphicalViewer && (this.isInState(2) || this.isInState(1))) {
            EditPart selectedEditPart = this.getTargetEditPart();
            if (this.getCurrentInput().isShiftKeyDown()) {
                EObject object;
                if (selectedEditPart instanceof IGraphicalEditPart && (object = ((IGraphicalEditPart)selectedEditPart).resolveSemanticElement()) instanceof EModelElement) {
                    Request request = new Request((Object)"open");
                    selectedEditPart.performRequest(request);
                    return true;
                }
            } else {
                EditPart ep;
                if (selectedEditPart instanceof RenderedDiagramRootEditPart && viewer.getSelectedEditParts().size() == 1 && ((ep = (EditPart)viewer.getSelectedEditParts().get(0)) instanceof GroupEditPart || ep instanceof Group2EditPart)) {
                    selectedEditPart = ep;
                }
                if (!(selectedEditPart instanceof ITextAwareEditPart) && selectedEditPart instanceof IGraphicalEditPart) {
                    IGraphicalEditPart nodePart = (IGraphicalEditPart)selectedEditPart;
                    if (nodePart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                        nodePart = (IGraphicalEditPart)nodePart.getParent();
                    }
                    ITextAwareEditPart textAwareEditPart = null;
                    for (Object child : nodePart.getChildren()) {
                        if (!(child instanceof ITextAwareEditPart)) continue;
                        textAwareEditPart = (ITextAwareEditPart)child;
                        break;
                    }
                    if (textAwareEditPart != null) {
                        selectedEditPart = textAwareEditPart;
                    }
                }
                if (selectedEditPart instanceof ITextAwareEditPart) {
                    Request request = new Request((Object)"direct edit");
                    selectedEditPart.performRequest(request);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (e.stateMask == SWT.MOD1 && e.keyCode == 32) {
            EditPart part = this.getTargetEditPart();
            if (!(part instanceof IGraphicalEditPart)) {
                return super.handleKeyDown(e);
            }
            IGraphicalEditPart selectedEditPart = (IGraphicalEditPart)part;
            EditPolicy ep = selectedEditPart.getEditPolicy((Object)"PopupBarEditPolicy");
            PopupBarEditPolicyEx editPolicy = (PopupBarEditPolicyEx)((Object)(ep instanceof PopupBarEditPolicyEx ? ep : null));
            if (editPolicy == null) {
                IGraphicalEditPart child = selectedEditPart.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5002));
                if (child != null) {
                    IGraphicalEditPart border;
                    Rectangle rect = selectedEditPart.getFigure().getBounds().getCopy();
                    Point loc = this.getLocation().getCopy();
                    selectedEditPart.getFigure().translateToRelative((Translatable)loc);
                    if (loc.y - (rect.y + rect.height) < 14 && (border = selectedEditPart.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5003))) != null) {
                        child = border;
                    }
                }
                if (child == null && (child = selectedEditPart.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5003))) == null) {
                    child = selectedEditPart.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5001));
                }
                if (child != null) {
                    ep = child.getEditPolicy((Object)"PopupBarEditPolicy");
                    editPolicy = (PopupBarEditPolicyEx)((Object)(ep instanceof PopupBarEditPolicyEx ? ep : null));
                }
            }
            if (editPolicy != null) {
                editPolicy.showDiagramAssistant();
                return false;
            }
        } else if (e.keyCode == 32) {
            this.spacePressed = true;
            this.setCursor(SharedCursors.SIZEWE);
        }
        return super.handleKeyDown(e);
    }

    protected boolean handleButtonDown(int button) {
        if (this.spacePressed && button == 1) {
            MultipleShapesMoveTool t = new MultipleShapesMoveTool(){
                private boolean dont = false;

                public boolean handleButtonDown(int button) {
                    if (this.dont) {
                        SelectionToolEx.this.spacePressed = false;
                        this.setCursor(SelectionToolEx.this.getDefaultCursor());
                        SelectionToolEx t = SelectionToolEx.this;
                        t.setViewer(this.getCurrentViewer());
                        t.handleButtonDown(1);
                        this.getDomain().setActiveTool((Tool)t);
                        t.setTargetEditPart(SelectionToolEx.this.getTargetEditPart());
                        this.deactivate();
                        return false;
                    }
                    this.dont = true;
                    return super.handleButtonDown(button);
                }
            };
            t.setViewer(this.getCurrentViewer());
            this.getDomain().setActiveTool((Tool)t);
            t.handleButtonDown(1);
            return true;
        }
        return super.handleButtonDown(button);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        this.spacePressed = false;
        if (this.getDomain().getActiveTool() == this) {
            this.setCursor(this.getDefaultCursor());
        }
        return super.handleKeyUp(e);
    }

    protected EditPartViewer.Conditional getTargetingConditional() {
        return new EditPartViewer.Conditional(){

            public boolean evaluate(EditPart editpart) {
                if (editpart instanceof GroupEditPart || editpart instanceof Group2EditPart) {
                    boolean onY;
                    IGraphicalEditPart part = (IGraphicalEditPart)editpart;
                    Rectangle rect = part.getFigure().getBounds().getCopy();
                    Point loc = SelectionToolEx.this.getLocation().getCopy();
                    part.getFigure().translateToRelative((Translatable)loc);
                    boolean onX = Math.abs(loc.x - rect.x) < 5 || Math.abs(loc.x - (rect.x + rect.width)) < 5;
                    boolean bl = onY = Math.abs(loc.y - rect.y) < 5 || Math.abs(loc.y - (rect.y + rect.height)) < 5;
                    if (!onX && !onY) {
                        return false;
                    }
                }
                if (editpart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                    return !SelectionToolEx.this.getCurrentInput().isModKeyDown(SWT.MOD1);
                }
                return editpart.isSelectable();
            }
        };
    }
}

