/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.export;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.l10n.DiagramUIRenderMessages;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.export.ExportImagePage;
import org.eclipse.stp.bpmn.export.IExportImagePage;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ImageExportWizard
extends Wizard
implements IExportWizard {
    protected IExportImagePage imagePage;
    private IStructuredSelection selection;

    public boolean performFinish() {
        List exporting = this.imagePage.getSelectedResources();
        if (exporting.isEmpty()) {
            ((DialogPage)this.imagePage).setErrorMessage(BpmnDiagramMessages.ImageExportWizard_NoResourcesSelectedError);
            return false;
        }
        for (Object toExport : exporting) {
            if (toExport == null || !(toExport instanceof IFile)) {
                return false;
            }
            if (((IFile)toExport).getFileExtension().equals("bpmn_diagram")) continue;
            ((DialogPage)this.imagePage).setErrorMessage(BpmnDiagramMessages.ImageExportWizard_InvalidExtensionError);
            return false;
        }
        if (exporting.size() > 1) {
            ((DialogPage)this.imagePage).setErrorMessage(BpmnDiagramMessages.ImageExportWizard_SelectOneDiagramError);
            return false;
        }
        Object selected = this.imagePage.getSelectedResources().get(0);
        IRunnableWithProgress runnable = this.createRunnable((IFile)selected, this.imagePage.getDestinationPath(), this.imagePage.getImageFormat());
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            progressMonitorDialog.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getTargetException().getMessage(), (Throwable)e.getTargetException());
            if (e.getTargetException() instanceof OutOfMemoryError) {
                this.openErrorDialog(DiagramUIRenderMessages.CopyToImageAction_outOfMemoryMessage);
            } else if (e.getTargetException() instanceof SWTError) {
                this.openErrorDialog(DiagramUIRenderMessages.CopyToImageAction_outOfMemoryMessage);
            } else {
                this.openErrorDialog(e.getTargetException().getMessage());
            }
            return true;
        }
        catch (InterruptedException e) {
            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void openErrorDialog(String message) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DiagramUIRenderMessages.CopyToImageAction_copyToImageErrorDialogTitle, (String)NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_copyToImageErrorDialogMessage, (Object)message));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(BpmnDiagramMessages.ImageExportWizard_title);
        this.selection = selection;
    }

    public void addPages() {
        super.addPages();
        this.imagePage = new ExportImagePage(this.selection);
        this.addPage(this.imagePage);
    }

    private IRunnableWithProgress createRunnable(final IFile diagram, final IPath destination, final ImageFileFormat format) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
                Resource res = resourceSet.getResource(URI.createPlatformResourceURI((String)diagram.getFullPath().toString(), (boolean)true), true);
                Diagram tempD = null;
                for (Object resElt : res.getContents()) {
                    if (!(resElt instanceof Diagram)) continue;
                    tempD = (Diagram)resElt;
                }
                if (tempD == null) {
                    return;
                }
                Diagram diagram2 = tempD;
                try {
                    new CopyToImageUtil().copyToImage(diagram2, destination, format, (IProgressMonitor)new NullProgressMonitor(), BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                }
                catch (CoreException e) {
                    BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, e.getMessage(), (Throwable)e));
                }
            }
        };
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }
}

