/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.tools.ConnectionValidator;

public class EdgeConnectionValidator
implements ConnectionValidator {
    public static EdgeConnectionValidator INSTANCE = new EdgeConnectionValidator();

    protected EdgeConnectionValidator() {
    }

    public boolean canStart(EObject element) {
        if (!(element instanceof Activity)) {
            return false;
        }
        Activity act = (Activity)element;
        int activityType = act.getActivityType().getValue();
        switch (activityType) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return false;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                if (act.getOutgoingEdges().size() <= 0) break;
                act.getIncomingEdges().size();
            }
        }
        return true;
    }

    public boolean canStart(EditPart sourceEditPart) {
        if (sourceEditPart instanceof ActivityEditPart) {
            EObject element = ((Node)sourceEditPart.getModel()).getElement();
            return this.canStart(element);
        }
        return sourceEditPart instanceof Activity2EditPart || sourceEditPart instanceof SubProcessEditPart;
    }

    public boolean canEnd(EObject element) {
        if (!(element instanceof Activity)) {
            return false;
        }
        Activity act = (Activity)element;
        int activityType = act.getActivityType().getValue();
        switch (activityType) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                if (act.getOutgoingEdges().size() <= 1) break;
                act.getIncomingEdges().size();
            }
        }
        return true;
    }

    public boolean canEnd(EditPart targetEditPart) {
        if (targetEditPart instanceof ActivityEditPart) {
            EObject element = ((Node)targetEditPart.getModel()).getElement();
            return this.canEnd(element);
        }
        if (targetEditPart instanceof Activity2EditPart) {
            return false;
        }
        return targetEditPart instanceof SubProcessEditPart;
    }

    public boolean canConnect(EObject source, EObject target) {
        if (source.equals(target)) {
            return false;
        }
        if (!this.canEnd(target)) {
            return false;
        }
        if (!this.canStart(source)) {
            return false;
        }
        if (((Activity)source).getEventHandlerFor() != null) {
            if (!this.getGraph(source).equals(this.getGraph(target)) && !this.getGraph((EObject)this.getGraph(source)).equals(this.getGraph(target))) {
                return false;
            }
            if (this.getGraph(source).equals(target)) {
                return false;
            }
        } else if (!((Vertex)source).getGraph().equals(((Vertex)target).getGraph())) {
            return false;
        }
        return true;
    }

    public boolean canConnect(EditPart source, EditPart target) {
        if (source.equals(target)) {
            return false;
        }
        if (!this.canEnd(target)) {
            return false;
        }
        if (!this.canStart(source)) {
            return false;
        }
        if (source instanceof Activity2EditPart) {
            if (!this.getGraph(source).equals(this.getGraph(target)) && !this.getGraph(this.getGraph(source)).equals(this.getGraph(target))) {
                return false;
            }
            if (this.getGraph(source).equals(target)) {
                return false;
            }
        } else if (!this.getGraph(source).equals(this.getGraph(target))) {
            return false;
        }
        return true;
    }

    protected EditPart getGraph(EditPart ep) {
        if (ep instanceof PoolEditPart) {
            return ep;
        }
        EditPart parent = ep.getParent();
        while (!(parent instanceof PoolEditPart) && parent != null) {
            if (parent instanceof SubProcessEditPart) break;
            parent = parent.getParent();
        }
        return parent;
    }

    protected Graph getGraph(EObject obj) {
        if (obj instanceof Graph) {
            return (Graph)obj;
        }
        EObject parent = obj.eContainer();
        if (parent != null) {
            return this.getGraph(parent);
        }
        return null;
    }
}

