/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.MessageVertex;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.MessagingEdgeItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.stp.bpmn.figures.ConnectionLayerExEx;
import org.eclipse.stp.bpmn.figures.ConnectionUtils;
import org.eclipse.stp.bpmn.figures.MessagePolylineSourceDecoration;
import org.eclipse.stp.bpmn.figures.MessagePolylineTargetDecoration;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;
import org.eclipse.swt.graphics.RGB;

public class MessagingEdgeEditPart
extends ConnectionNodeEditPart {
    private static final int[] DASHES = new int[]{7, 5};
    public static final int VISUAL_ID = 3002;
    private ConnectionRouter rectilinearRouter = null;
    protected EditPart srcConnEditPart = null;
    protected EditPart trgConnEditPart = null;

    public MessagingEdgeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new MessagingEdgeItemSemanticEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)this.createOpenFileEditPolicy());
    }

    protected OpenFileEditPolicy createOpenFileEditPolicy() {
        return new OpenFileEditPolicy();
    }

    protected Connection createConnectionFigure() {
        return new ConnectionMessageFigure();
    }

    protected void installRouter() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        if (style != null && cLayer instanceof ConnectionLayerExEx) {
            ConnectionLayerExEx cLayerEx = (ConnectionLayerExEx)cLayer;
            if (Routing.RECTILINEAR_LITERAL == style.getRouting()) {
                if (this.rectilinearRouter == null) {
                    this.rectilinearRouter = cLayerEx.getBpmnMessagingEdgeRectilinearRouter();
                }
                this.getConnectionFigure().setConnectionRouter(this.rectilinearRouter);
                ((ConnectionMessageFigure)this.getFigure()).routerIsRectilinear = true;
                this.refreshRouterChange();
                return;
            }
        } else {
            throw new IllegalArgumentException("Invalid layer: " + cLayer);
        }
        ((ConnectionMessageFigure)this.getFigure()).routerIsRectilinear = false;
        super.installRouter();
    }

    private static EditPart getRealEditPart(EditPart editPart) {
        EditPart res = editPart;
        EditPart parent = editPart.getParent();
        while (!(parent instanceof PoolPoolCompartmentEditPart)) {
            boolean isCollapsed;
            if (parent instanceof SubProcessSubProcessBodyCompartmentEditPart && (isCollapsed = ((Boolean)((SubProcessSubProcessBodyCompartmentEditPart)parent).getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed())).booleanValue())) {
                res = parent.getParent();
            }
            parent = parent.getParent();
        }
        return res;
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        EditPart newSrcEditPart;
        this.srcConnEditPart = null;
        EditPart editPart = this.getSource();
        if (editPart instanceof PoolEditPart) {
            return super.getSourceConnectionAnchor();
        }
        if (editPart != null && (newSrcEditPart = MessagingEdgeEditPart.getRealEditPart(editPart)) != editPart) {
            EditPart targetEditPart = this.getTarget();
            if (targetEditPart != null) {
                targetEditPart = MessagingEdgeEditPart.getRealEditPart(targetEditPart);
            }
            if (newSrcEditPart != targetEditPart) {
                this.srcConnEditPart = newSrcEditPart;
                ConnectionAnchor ca = ((NodeEditPart)this.srcConnEditPart).getSourceConnectionAnchor((ConnectionEditPart)this);
                this.updateConnectionAnchor(ca, true);
                return ca;
            }
            this.srcConnEditPart = editPart;
        }
        ConnectionAnchor ca = super.getSourceConnectionAnchor();
        this.updateConnectionAnchor(ca, true);
        return ca;
    }

    protected void updateConnectionAnchor(ConnectionAnchor ca, boolean isSource) {
        if (ca instanceof IModelAwareAnchor) {
            IModelAwareAnchor modelAware = (IModelAwareAnchor)ca;
            MessagingEdge msgEdge = (MessagingEdge)this.getPrimaryView().getElement();
            EditPart part = isSource ? this.srcConnEditPart : this.trgConnEditPart;
            Object messages = null;
            int count = 0;
            if (part instanceof SubProcessEditPart) {
                LinkedList messagesList = new LinkedList();
                this.collectMessagingEdges((Graph)((IGraphicalEditPart)part).resolveSemanticElement(), messagesList);
                count = messagesList.size();
                messages = messagesList.iterator();
                if (!isSource) {
                    ((ConnectionMessageFigure)this.getFigure()).setTargetDecorationStyle(true);
                }
            } else {
                Activity connectedActivity = isSource ? (Activity)((GraphicalEditPart)super.getSource()).resolveSemanticElement() : (Activity)((GraphicalEditPart)super.getTarget()).resolveSemanticElement();
                messages = connectedActivity.getOrderedMessages().valueListIterator();
                count = connectedActivity.getOrderedMessages().size();
                if (!isSource) {
                    ((ConnectionMessageFigure)this.getFigure()).setTargetDecorationStyle(connectedActivity.getActivityType().getLiteral().startsWith("Event"));
                }
            }
            int ind = 0;
            while (messages.hasNext()) {
                MessagingEdge entry = (MessagingEdge)messages.next();
                if (msgEdge.equals(entry)) break;
                ++ind;
            }
            if (ind == count) {
                ind = -1;
            }
            modelAware.setConnectionType(isSource, String.valueOf(3002), ind, count);
        }
    }

    protected void collectMessagingEdges(Graph container, List msgEdges) {
        for (Object v : container.getVertices()) {
            if (v instanceof Activity) {
                for (Object msgEntry : ((Activity)v).getOrderedMessages()) {
                    msgEdges.add(((FeatureMap.Entry)msgEntry).getValue());
                }
            }
            if (!(v instanceof SubProcess)) continue;
            this.collectMessagingEdges((Graph)v, msgEdges);
        }
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        EditPart newTargetEditPart;
        this.trgConnEditPart = null;
        EditPart editPart = this.getTarget();
        if (editPart instanceof PoolEditPart) {
            return super.getTargetConnectionAnchor();
        }
        if (editPart != null && (newTargetEditPart = MessagingEdgeEditPart.getRealEditPart(editPart)) != editPart) {
            EditPart srcEditPart = this.getSource();
            if (srcEditPart != null) {
                srcEditPart = MessagingEdgeEditPart.getRealEditPart(srcEditPart);
            }
            if (newTargetEditPart != srcEditPart) {
                this.trgConnEditPart = newTargetEditPart;
                ConnectionAnchor ca = ((NodeEditPart)this.trgConnEditPart).getTargetConnectionAnchor((ConnectionEditPart)this);
                this.updateConnectionAnchor(ca, false);
                return ca;
            }
            this.trgConnEditPart = editPart;
        }
        ConnectionAnchor ca = super.getTargetConnectionAnchor();
        this.updateConnectionAnchor(ca, false);
        return ca;
    }

    private boolean isReparented() {
        return this.srcConnEditPart != null && this.srcConnEditPart != this.getSource() || this.trgConnEditPart != null && this.trgConnEditPart != this.getTarget();
    }

    protected void handleNotificationEvent(Notification notification) {
        String newValue;
        Object feature = notification.getFeature();
        if (feature instanceof EAttribute && "anchor".equals(((EAttribute)feature).getDefaultValueLiteral()) && (newValue = notification.getNewStringValue()) != null) {
            MessageVertex activity;
            boolean isSource;
            PrecisionPoint p = BaseSlidableAnchor.parseTerminalString((String)newValue);
            IdentityAnchor notifier = (IdentityAnchor)notification.getNotifier();
            Edge connection = (Edge)notifier.eContainer();
            if (connection.getSourceAnchor() == notifier) {
                isSource = true;
                activity = (MessageVertex)connection.getSource().getElement();
            } else {
                isSource = false;
                activity = (MessageVertex)connection.getTarget().getElement();
            }
            FeatureMap messages = activity.getOrderedMessages();
            int connCount = messages.size();
            int newIdx = -1;
            int i = 0;
            while (i < connCount) {
                if (p.preciseX < 1.0 / (double)connCount * (double)(i + 1)) {
                    newIdx = i;
                    break;
                }
                ++i;
            }
            if (newIdx != -1) {
                int oldInd = 0;
                for (FeatureMap.Entry entry : messages) {
                    if (entry.getValue() == connection.getElement()) break;
                    ++oldInd;
                }
                if (oldInd < messages.size()) {
                    messages.move(newIdx, oldInd);
                }
                EditPart activityEditPart = isSource ? this.getSource() : this.getTarget();
                activityEditPart.refresh();
            }
        }
        super.handleNotificationEvent(notification);
    }

    public class ConnectionMessageFigure
    extends PolylineConnectionEx {
        private static final int DELTA_ANCHOR_SIZE = 10;
        private boolean routerIsRectilinear = true;

        public void paintFigure(Graphics graphics) {
            graphics.setAlpha(ActivityPainter.getMessagingEdgeTransparency());
            super.paintFigure(graphics);
        }

        public ConnectionMessageFigure() {
            this.setLineStyle(6);
            this.setLineDash(DASHES);
            this.setForegroundColor(FigureUtilities.integerToColor((Integer)FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)BpmnDiagramEditorPlugin.PREF_STORE, (String)BpmnDiagramPreferenceInitializer.PREF_MSG_LINE_COLOR))));
            this.setSourceDecoration(this.createSourceDecoration());
            this.setTargetDecoration((RotatableDecoration)this.createTargetDecoration());
        }

        private MessagePolylineSourceDecoration createSourceDecoration() {
            MessagePolylineSourceDecoration df = new MessagePolylineSourceDecoration();
            return df;
        }

        private MessagePolylineTargetDecoration createTargetDecoration() {
            MessagePolylineTargetDecoration df = new MessagePolylineTargetDecoration(true);
            return df;
        }

        public PointList getSmoothPoints() {
            PointList smoothPoints = !this.routerIsRectilinear ? super.getSmoothPoints() : ConnectionUtils.getRoundedRectilinearSmoothPoints(true, this.getPoints(), this.getSmoothness());
            return smoothPoints;
        }

        public void setVisible(boolean visible) {
            if (MessagingEdgeEditPart.this.isReparented()) {
                visible = true;
            }
            super.setVisible(visible);
        }

        public void setTargetDecorationStyle(boolean isRoundStyle) {
            ((MessagePolylineTargetDecoration)this.getTargetDecoration()).setStyle(isRoundStyle);
        }
    }
}

