/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.figures.SubProcessBodyFigure;
import org.eclipse.stp.bpmn.figures.SubProcessBorderFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.figures.connectionanchors.DefaultSizeNodeFigureEx;
import org.eclipse.stp.bpmn.figures.connectionanchors.IConnectionAnchorFactory;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.layouts.SubProcessLayout;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.DelegateToCompartmentEditPolicy;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;
import org.eclipse.stp.bpmn.policies.ResizableSubProcessEditPolicy;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;
import org.eclipse.stp.gmf.runtime.draw2d.ui.figures.WrappingLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcessEditPart
extends ShapeNodeEditPart {
    public static final int COLLAPSE_HANDLE_HEIGHT = 20;
    public static final int BORDER_HEIGHT = 50;
    public static final Dimension COLLAPSED_SIZE = new Dimension(111, 71);
    public static final Dimension EXPANDED_SIZE = new Dimension(111, 96);
    public static final int VISUAL_ID = 2002;
    protected boolean needToUpdateContainer;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    public static final Insets INSETS = new Insets(2, 2, 2, 2);

    public SubProcessEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy(){

            public Command getCommand(Request request) {
                if (this.understandsRequest(request)) {
                    CreateElementRequestAdapter adapter;
                    IElementType type;
                    if (request instanceof CreateViewAndElementRequest && (type = (IElementType)(adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter()).getAdapter(IElementType.class)) == BpmnElementTypes.Activity_2003) {
                        IGraphicalEditPart compartmentEditPart = SubProcessEditPart.this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5003));
                        return compartmentEditPart == null ? null : compartmentEditPart.getCommand(request);
                    }
                    return super.getCommand(request);
                }
                return null;
            }
        });
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SubProcessItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new SubProcessGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new SubProcessCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("CreationPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)this.createConnectionHandlerEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new DelegateToCompartmentEditPolicy(BpmnVisualIDRegistry.getType(5002), "ContainerEditPolicy"));
        this.installEditPolicy("OpenPolicy", (EditPolicy)this.createOpenFileEditPolicy());
    }

    protected OpenFileEditPolicy createOpenFileEditPolicy() {
        return new OpenFileEditPolicy();
    }

    protected DiagramAssistantEditPolicy createConnectionHandlerEditPolicy() {
        return new ConnectionHandleEditPolicyEx();
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        SubProcessFigure figure = new SubProcessFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public SubProcessFigure getPrimaryShape() {
        return (SubProcessFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof SubProcessNameEditPart) {
            ((SubProcessNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureSubProcessNameFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            SubProcessBodyFigure pane = this.getPrimaryShape().getFigureSubProcessBodyFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((SubProcessSubProcessBodyCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
            SubProcessBorderFigure pane = this.getPrimaryShape().getFigureSubProcessBorderFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((SubProcessSubProcessBorderCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            SubProcessBodyFigure pane = this.getPrimaryShape().getFigureSubProcessBodyFigure();
            pane.remove(((SubProcessSubProcessBodyCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
            SubProcessBorderFigure pane = this.getPrimaryShape().getFigureSubProcessBorderFigure();
            pane.remove(((SubProcessSubProcessBorderCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected IConnectionAnchorFactory getConnectionAnchorFactory() {
        return ConnectionAnchorFactory.INSTANCE;
    }

    protected NodeFigure createNodePlate() {
        return new DefaultSizeNodeFigureEx(this.getMapMode().DPtoLP(SubProcessEditPart.EXPANDED_SIZE.width), this.getMapMode().DPtoLP(SubProcessEditPart.EXPANDED_SIZE.height), this.getConnectionAnchorFactory()){

            public Rectangle getHandleBounds() {
                SubProcessFigure figure = SubProcessEditPart.this.getPrimaryShape();
                return figure.getHandleBounds();
            }

            public void setBounds(Rectangle rect) {
                Rectangle currentBounds = this.getBounds();
                int widthDiff = rect.width - currentBounds.width;
                int heightDiff = rect.height - currentBounds.height;
                ((SubProcessFigure)SubProcessEditPart.this.getPrimaryShape()).fSubProcessBodyFigure.getBounds().height += heightDiff;
                super.setBounds(rect);
            }

            public void computeAbsoluteHandleBounds(Rectangle result) {
                result.setBounds(this.getHandleBounds());
                super.translateToAbsolute((Translatable)result);
            }
        };
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(0);
            nodeShape.setLayoutManager((LayoutManager)layout);
            nodeShape.setBorder(null);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4006));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected void paintCompensationMarker(Graphics graphics) {
        SubProcess model = (SubProcess)((View)this.getModel()).getElement();
        for (Object o : model.getIncomingEdges()) {
            Activity src;
            SequenceEdge e = (SequenceEdge)o;
            if (e.getSource() == null || !(e.getSource() instanceof Activity) || (src = (Activity)e.getSource()).getActivityType().getValue() != 12) continue;
            int size = 18;
            Rectangle bounds = this.getAbsBoundsWithoutBorder();
            this.getPrimaryShape().translateToRelative((Translatable)bounds);
            Rectangle loopRect = new Rectangle();
            loopRect.x = bounds.x + bounds.width / 2 + size;
            loopRect.y = bounds.y + bounds.height - size - 2;
            loopRect.height = size;
            loopRect.width = size;
            ActivityPainter.paintCompensation(graphics, loopRect, MapModeUtil.getMapMode((IFigure)this.getFigure()).LPtoDP(1));
            break;
        }
    }

    protected void paintMultipleInstances(Graphics graphics) {
        if (this.shouldPaintMultipleInstances()) {
            int size = 20;
            Rectangle bounds = this.getAbsBoundsWithoutBorder();
            this.getPrimaryShape().translateToRelative((Translatable)bounds);
            Rectangle loopRect = new Rectangle();
            loopRect.x = bounds.x + bounds.width / 2 - size + 4;
            loopRect.y = bounds.y + bounds.height - size + 2;
            if (this.getPrimaryShape().getFigureSubProcessBorderFigure().hasChildren()) {
                loopRect.y = (int)((double)loopRect.y - 30.0 * this.getZoom() / 2.0);
            }
            loopRect.height = size - 4;
            loopRect.width = size - 6;
            if (BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("bpmn.1.1.style")) {
                int width = 2;
                graphics.pushState();
                graphics.setBackgroundColor(ColorConstants.black);
                graphics.fillRectangle(loopRect.x, loopRect.y, width, loopRect.height);
                graphics.fillRectangle(loopRect.x + (-width + loopRect.width) / 2, loopRect.y, width, loopRect.height);
                graphics.fillRectangle(loopRect.x + loopRect.width - width, loopRect.y, width, loopRect.height);
                graphics.popState();
            } else {
                int width = size / 2 - 4;
                graphics.pushState();
                graphics.setBackgroundColor(ColorConstants.black);
                graphics.fillRectangle(loopRect.x, loopRect.y, width, loopRect.height);
                graphics.fillRectangle(loopRect.x + loopRect.width - width, loopRect.y, width, loopRect.height);
                graphics.popState();
            }
        }
    }

    protected boolean shouldPaintMultipleInstances() {
        return false;
    }

    private boolean isTransactional() {
        if (!(this.resolveSemanticElement() instanceof SubProcess)) {
            return false;
        }
        SubProcess sp = (SubProcess)this.resolveSemanticElement();
        String ann = EcoreUtil.getAnnotation((EModelElement)sp, (String)"isThrowing", (String)"isThrowing");
        return ann != null && !ann.equals("false");
    }

    protected void paintLoopMarker(Graphics graphics) {
        SubProcess zmodel = (SubProcess)((View)this.getModel()).getElement();
        if (zmodel.isLooping()) {
            int size = 20;
            Rectangle bounds = this.getAbsBoundsWithoutBorder();
            this.getPrimaryShape().translateToRelative((Translatable)bounds);
            Rectangle loopRect = new Rectangle();
            loopRect.x = bounds.x + bounds.width / 2 - size;
            loopRect.y = bounds.y + bounds.height - size;
            if (this.getPrimaryShape().getFigureSubProcessBorderFigure().hasChildren()) {
                loopRect.y = (int)((double)loopRect.y - 30.0 * this.getZoom() / 2.0);
            }
            loopRect.height = size;
            loopRect.width = size;
            ActivityPainter.paintLoop(graphics, new PrecisionRectangle(loopRect), this.getFigure());
        }
    }

    private Rectangle getChildrenBounds(EditPart editPart) {
        Rectangle r = new Rectangle();
        boolean isFirst = true;
        for (Object object : editPart.getChildren()) {
            GraphicalEditPart child = (GraphicalEditPart)object;
            if (!isFirst) {
                Rectangle dim = child.getFigure().getBounds().getCopy();
                r.union(dim);
                continue;
            }
            r = child.getFigure().getBounds().getCopy();
            isFirst = false;
        }
        return r;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableSubProcessEditPolicy();
    }

    protected void refreshBounds() {
        super.refreshBounds();
    }

    protected Rectangle getAbsBoundsWithoutBorder() {
        SubProcessFigure figure = this.getPrimaryShape();
        Rectangle theBounds = figure.getHandleBounds();
        figure.translateToAbsolute((Translatable)theBounds);
        return theBounds;
    }

    public double getZoom() {
        double zoom = 1.0;
        RootEditPart rootEditPart = this.getRoot();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            zoom = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager().getZoom();
        }
        return zoom;
    }

    public Rectangle getAbsCollapseHandleBounds(boolean zoomCompute) {
        double zoom = zoomCompute ? this.getZoom() : 1.0;
        double size = 20.0 * zoom;
        Rectangle theBounds = this.getAbsBoundsWithoutBorder();
        PrecisionRectangle handleBounds = new PrecisionRectangle(theBounds);
        handleBounds.setX((double)handleBounds.x + ((double)handleBounds.width - size) / 2.0);
        handleBounds.setY((double)(handleBounds.y + handleBounds.height) - size);
        if (this.getPrimaryShape().getFigureSubProcessBorderFigure().hasChildren()) {
            handleBounds.setY((double)handleBounds.y - 30.0 * zoom / 2.0);
        }
        handleBounds.setWidth(size);
        handleBounds.setHeight(size);
        SubProcess model = (SubProcess)((View)this.getModel()).getElement();
        if (model.isLooping()) {
            handleBounds.setX((double)handleBounds.x + size / 2.0 + 1.0);
        }
        return handleBounds;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1 && BpmnPackage.eINSTANCE.getActivity_Looping().equals(notification.getFeature())) {
            this.figure.repaint();
        }
        if (NotationPackage.eINSTANCE.getSize_Width().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getSize_Height().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getLocation_X().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getLocation_Y().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getLocation().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getLayoutConstraint().equals(notification.getFeature())) {
            for (Object e : this.getSourceConnections()) {
                if (!(e instanceof ConnectionEditPart)) continue;
                ((ConnectionEditPart)e).getTarget().refresh();
            }
            for (Object e : this.getTargetConnections()) {
                if (!(e instanceof ConnectionEditPart)) continue;
                ((ConnectionEditPart)e).getSource().refresh();
            }
            this.refresh();
        }
        super.handleNotificationEvent(notification);
    }

    public DragTracker getDragTracker(Request request) {
        return new TaskDragEditPartsTrackerEx((IGraphicalEditPart)this);
    }

    public Command getCommand(Request _request) {
        if (_request instanceof CreateUnspecifiedTypeConnectionRequest) {
            if (((CreateUnspecifiedTypeConnectionRequest)_request).getTargetEditPart() == null) {
                if (((IGraphicalEditPart)((CreateUnspecifiedTypeConnectionRequest)_request).getSourceEditPart()).resolveSemanticElement().eContainer().equals(this.resolveSemanticElement())) {
                    return this.getEditPolicy("ContainerEditPolicy").getCommand(_request);
                }
                Command co = super.getCommand(_request);
                return co;
            }
            Object model = ((CreateUnspecifiedTypeConnectionRequest)_request).getTargetEditPart().getModel();
            if (model instanceof Node) {
                List elTypes = ((CreateUnspecifiedTypeConnectionRequest)_request).getElementTypes();
                MetamodelType connType = (MetamodelType)BpmnElementTypes.MessagingEdge_3002;
                int i = 0;
                while (i < elTypes.size()) {
                    if (elTypes.get(i) instanceof MetamodelType) {
                        connType = (MetamodelType)elTypes.get(i);
                        break;
                    }
                    ++i;
                }
                if (connType == BpmnElementTypes.MessagingEdge_3002) {
                    return null;
                }
                if (connType == BpmnElementTypes.SequenceEdge_3001 && _request instanceof CreateUnspecifiedTypeConnectionRequest) {
                    CreateUnspecifiedTypeConnectionRequest request = (CreateUnspecifiedTypeConnectionRequest)_request;
                    if (request.getSourceEditPart() != null) {
                        EditPart ancestor = request.getSourceEditPart().getParent();
                        while (ancestor != null) {
                            if (ancestor == this) {
                                IGraphicalEditPart bodyCompartment = this.getChildBySemanticHint("5002");
                                if (bodyCompartment == null) break;
                                return bodyCompartment.getCommand((Request)request);
                            }
                            ancestor = ancestor.getParent();
                        }
                    }
                    EdgeConnectionValidator edgeValidator = EdgeConnectionValidator.INSTANCE;
                    if (!request.isDirectionReversed() && request.getSourceEditPart() != null && request.getTargetEditPart() != null) {
                        for (CreateConnectionRequest connectionRequest : request.getAllRequests()) {
                            if (connectionRequest.getSourceEditPart() == null || connectionRequest.getTargetEditPart() == null || connectionRequest.getSourceEditPart() != request.getSourceEditPart() || connectionRequest.getTargetEditPart() != request.getTargetEditPart() || edgeValidator.canConnect(request.getSourceEditPart(), request.getTargetEditPart())) continue;
                            return null;
                        }
                    }
                }
            }
        }
        return super.getCommand(_request);
    }

    private void updateAnchors(boolean sourceOnly) {
        Node thisModel;
        View model;
        ConnectionEditPart connEditPart;
        HashMap<EObject, ConnectionEditPart> connIndex = new HashMap<EObject, ConnectionEditPart>();
        for (Object object : this.getSourceConnections()) {
            connEditPart = (ConnectionEditPart)object;
            model = (View)connEditPart.getModel();
            connIndex.put(model.getElement(), connEditPart);
        }
        for (Object object : this.getTargetConnections()) {
            connEditPart = (ConnectionEditPart)object;
            model = (View)connEditPart.getModel();
            connIndex.put(model.getElement(), connEditPart);
        }
        SubProcess sp = (SubProcess)this.resolveSemanticElement();
        if (sp == null) {
            return;
        }
        int totalLength = sp.getIncomingEdges().size() + sp.getOutgoingEdges().size();
        int i = 0;
        if (sourceOnly) {
            if (!ActivityEditPart.isOrderImportant((IGraphicalEditPart)this, true)) {
                thisModel = (Node)this.getModel();
                List<Edge> seqs = ActivityEditPart.getSourceSequenceEdges(thisModel, true);
                totalLength = seqs.size();
                int ind = 0;
                for (Edge edge : seqs) {
                    this.setAnchorIndex(connIndex, (EModelElement)edge.getElement(), i, totalLength, true);
                    ++ind;
                }
            } else {
                EList outEdges = sp.getOutgoingEdges();
                int ind = 0;
                totalLength = outEdges.size();
                for (SequenceEdge edge : outEdges) {
                    this.setAnchorIndex(connIndex, (EModelElement)edge, i, totalLength, true);
                    ++ind;
                }
            }
        } else if (!ActivityEditPart.isOrderImportant((IGraphicalEditPart)this, false)) {
            thisModel = (Node)this.getModel();
            List<Edge> seqs = ActivityEditPart.getTargetSequenceEdges(thisModel, true);
            totalLength = seqs.size();
            int ind = 0;
            for (Edge edge : seqs) {
                this.setAnchorIndex(connIndex, (EModelElement)edge.getElement(), i, totalLength, false);
                ++ind;
            }
        } else {
            EList inEdges = sp.getIncomingEdges();
            int ind = 0;
            totalLength = inEdges.size();
            for (SequenceEdge edge : inEdges) {
                this.setAnchorIndex(connIndex, (EModelElement)edge, ind, totalLength, false);
                ++ind;
            }
        }
        if (!sourceOnly) {
            int ii = 0;
            int l = sp.getAssociations().size();
            for (Association assoc : sp.getAssociations()) {
                this.setAnchorIndex(connIndex, (EModelElement)assoc, ii, l, false);
                ++i;
            }
        }
    }

    protected void setAnchorIndex(Map<EObject, ConnectionEditPart> connIndex, EModelElement semanticModelOfConn, int index, int totalLength, boolean isSource) {
        ConnectionEditPart conn = connIndex.get(semanticModelOfConn);
        if (conn != null) {
            ConnectionAnchor anchor;
            String edgeType = this.getEdgeType(semanticModelOfConn);
            PolylineConnectionEx connFigure = (PolylineConnectionEx)conn.getFigure();
            ConnectionAnchor connectionAnchor = anchor = isSource ? connFigure.getSourceAnchor() : connFigure.getTargetAnchor();
            if (anchor instanceof IModelAwareAnchor) {
                ((IModelAwareAnchor)anchor).setConnectionType(isSource, edgeType, index, totalLength);
                conn.refresh();
            }
        }
    }

    public void refreshSourceConnections() {
        try {
            super.refreshSourceConnections();
            this.updateAnchors(true);
        }
        catch (Exception e) {
            EObject eo = this.resolveSemanticElement();
            IllegalArgumentException e2 = new IllegalArgumentException("Corrupted model " + eo);
            e2.initCause(e);
            throw e2;
        }
    }

    public void refreshTargetConnections() {
        try {
            super.refreshTargetConnections();
            this.updateAnchors(false);
        }
        catch (Exception e) {
            EObject eo = this.resolveSemanticElement();
            IllegalArgumentException e2 = new IllegalArgumentException("Corrupted model " + eo);
            e2.initCause(e);
            throw e2;
        }
    }

    protected String getEdgeType(EModelElement obj) {
        if (obj instanceof SequenceEdge) {
            return String.valueOf(3001);
        }
        if (obj instanceof MessagingEdge) {
            return String.valueOf(3002);
        }
        if (obj instanceof Association) {
            return String.valueOf(3003);
        }
        return null;
    }

    public class SubProcessFigure
    extends org.eclipse.stp.bpmn.figures.SubProcessFigure {
        private WrappingLabel fSubProcessNameFigure;
        private SubProcessBodyFigure fSubProcessBodyFigure;
        private SubProcessBorderFigure fSubProcessBorderFigure;
        private boolean myUseLocalCoordinates = false;

        public SubProcessFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.createContents();
        }

        private void createContents() {
            this.setLayoutManager((LayoutManager)new SubProcessLayout());
            WrappingLabel spLabel = new WrappingLabel(){

                public void setBounds(Rectangle rect) {
                    rect.height += MapModeUtil.getMapMode((IFigure)this).DPtoLP(1);
                    super.setBounds(rect);
                }
            };
            spLabel.setAlignment(2);
            spLabel.setTextWrap(true);
            spLabel.setText("");
            this.setFigureSubProcessNameFigure(spLabel);
            Integer layData0 = 0;
            SubProcessBodyFigure spBody = new SubProcessBodyFigure(){

                public Dimension getMinimumSize(int hint, int hint2) {
                    GraphicalEditPart bodyEditPart = (GraphicalEditPart)SubProcessEditPart.this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5002));
                    boolean isCollapsed = (Boolean)bodyEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed());
                    if (!isCollapsed) {
                        return SubProcessEditPart.this.getChildrenBounds((EditPart)bodyEditPart).getSize();
                    }
                    return COLLAPSED_SIZE.getCopy();
                }
            };
            this.setFigureSubProcessBodyFigure(spBody);
            Integer layData1 = 1;
            SubProcessBorderFigure spBorder = new SubProcessBorderFigure(SubProcessEditPart.this.getMapMode(), !((SubProcess)SubProcessEditPart.this.resolveSemanticElement()).getEventHandlers().isEmpty());
            this.setFigureSubProcessBorderFigure(spBorder);
            Integer layData2 = 2;
            this.add((IFigure)spBody, layData1);
            this.add((IFigure)spBorder, layData2);
            this.add((IFigure)spLabel, layData0);
        }

        public WrappingLabel getFigureSubProcessNameFigure() {
            return this.fSubProcessNameFigure;
        }

        private void setFigureSubProcessNameFigure(WrappingLabel fig) {
            this.fSubProcessNameFigure = fig;
        }

        public SubProcessBodyFigure getFigureSubProcessBodyFigure() {
            return this.fSubProcessBodyFigure;
        }

        private void setFigureSubProcessBodyFigure(SubProcessBodyFigure fig) {
            this.fSubProcessBodyFigure = fig;
        }

        public SubProcessBorderFigure getFigureSubProcessBorderFigure() {
            return this.fSubProcessBorderFigure;
        }

        private void setFigureSubProcessBorderFigure(SubProcessBorderFigure fig) {
            this.fSubProcessBorderFigure = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            SubProcess model = (SubProcess)((View)SubProcessEditPart.this.getModel()).getElement();
            this.paintCollapseHandle(graphics);
            if (SubProcessEditPart.this.shouldPaintMultipleInstances()) {
                SubProcessEditPart.this.paintMultipleInstances(graphics);
            } else {
                SubProcessEditPart.this.paintLoopMarker(graphics);
                SubProcessEditPart.this.paintCompensationMarker(graphics);
            }
        }

        protected void outlineShape(Graphics graphics) {
            super.outlineShape(graphics);
            if (SubProcessEditPart.this.isTransactional()) {
                Rectangle f = Rectangle.SINGLETON;
                Rectangle r = this.getHandleBounds();
                f.x = r.x + this.lineWidth / 2;
                f.y = r.y + this.lineWidth / 2;
                f.width = r.width - this.lineWidth;
                f.height = r.height - this.lineWidth;
                f.crop(new Insets(5, 5, 5, 5));
                graphics.drawRoundRectangle(f, this.corner.width, this.corner.height);
            }
        }

        private void paintCollapseHandle(Graphics graphics) {
            GraphicalEditPart bodyEditPart = null;
            for (Object object : ((AbstractEditPart)SubProcessEditPart.this).children) {
                if (!(object instanceof SubProcessSubProcessBodyCompartmentEditPart)) continue;
                bodyEditPart = (GraphicalEditPart)object;
                break;
            }
            if (bodyEditPart == null) {
                return;
            }
            Rectangle bounds = SubProcessEditPart.this.getAbsCollapseHandleBounds(true);
            this.translateToRelative((Translatable)bounds);
            int lineWidth = 1;
            bounds.shrink(lineWidth, lineWidth);
            graphics.drawRectangle(bounds);
            graphics.setLineWidth(lineWidth *= 2);
            double delta = lineWidth;
            double y = (double)bounds.y + (double)bounds.height / 2.0;
            PrecisionPoint p1 = new PrecisionPoint((double)bounds.x + delta, y);
            PrecisionPoint p2 = new PrecisionPoint((double)(bounds.x + bounds.width) - delta, y);
            graphics.drawLine((Point)p1, (Point)p2);
            boolean isCollapsed = false;
            isCollapsed = bodyEditPart == null ? true : (Boolean)bodyEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed());
            if (isCollapsed) {
                double x = (double)bounds.x + (double)bounds.width / 2.0;
                p1 = new PrecisionPoint(x, (double)bounds.y + delta);
                p2 = new PrecisionPoint(x, (double)(bounds.y + bounds.height) - delta);
                graphics.drawLine((Point)p1, (Point)p2);
            }
        }

        public boolean isCollapsed() {
            GraphicalEditPart bodyEditPart = (GraphicalEditPart)SubProcessEditPart.this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5002));
            return (Boolean)bodyEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed());
        }
    }
}

