/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.commands.ElementTypeEx;
import org.eclipse.stp.bpmn.commands.IElementTypeEx;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMNElementTypesActivities {
    private static Collection<IElementTypeEx> TypesForSubProcessBorder;
    private static Collection<IElementTypeEx> TypesForPoolAndSubProcessBody;
    private static Collection<IElementTypeEx> TypesForSequenceEdgeSource;
    private static Collection<IElementTypeEx> TypesForSequenceEdgeTarget;
    private static Collection<IElementTypeEx> TypesForMessagingEdgeSource;
    private static Collection<IElementTypeEx> TypesForMessagingEdgeTarget;
    private static Collection<IElementType> TypesForAssociationTarget;
    private static Collection<IElementType> TypesForAssociationTargetSource;

    public static Collection<IElementTypeEx> getElementTypesForSubProcessBorder() {
        if (TypesForSubProcessBorder == null) {
            TypesForSubProcessBorder = Collections.unmodifiableCollection((Collection)Arrays.asList(ElementTypeEx.wrap(BpmnElementTypes.Activity_2003, ActivityType.EVENT_INTERMEDIATE_COMPENSATION_LITERAL.getLiteral()), ElementTypeEx.wrap(BpmnElementTypes.Activity_2003, ActivityType.EVENT_INTERMEDIATE_ERROR_LITERAL.getLiteral()), ElementTypeEx.wrap(BpmnElementTypes.Activity_2003, ActivityType.EVENT_INTERMEDIATE_TIMER_LITERAL.getLiteral())));
        }
        return TypesForSubProcessBorder;
    }

    public static Collection<IElementTypeEx> getElementTypesForPoolAndSubProcessBody() {
        if (TypesForPoolAndSubProcessBody == null) {
            TypesForPoolAndSubProcessBody = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                String name = ((ActivityType)at).getLiteral();
                IElementType elementType = "SubProcess".equals(name) ? BpmnElementTypes.SubProcess_2002 : BpmnElementTypes.Activity_2001;
                TypesForPoolAndSubProcessBody.add(ElementTypeEx.wrap(elementType, name));
            }
            TypesForPoolAndSubProcessBody.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_activity_label)));
            TypesForPoolAndSubProcessBody.add(ElementTypeEx.wrap(BpmnElementTypes.SubProcess_2002, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_sub_process_label)));
        }
        return TypesForPoolAndSubProcessBody;
    }

    public static Collection<IElementTypeEx> getElementTypesForSequenceEdgeSource() {
        if (TypesForSequenceEdgeSource == null) {
            TypesForSequenceEdgeSource = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                String name = attype.getLiteral();
                if (name.startsWith("EventEnd")) continue;
                IElementType elementType = "SubProcess".equals(name) ? BpmnElementTypes.SubProcess_2002 : BpmnElementTypes.Activity_2001;
                TypesForSequenceEdgeSource.add(ElementTypeEx.wrap(elementType, name));
            }
            TypesForSequenceEdgeSource.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_activity_label)));
            TypesForSequenceEdgeSource.add(ElementTypeEx.wrap(BpmnElementTypes.SubProcess_2002, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_sub_process_label)));
        }
        return TypesForSequenceEdgeSource;
    }

    public static Collection<IElementTypeEx> getElementTypesForSequenceEdgeTarget() {
        if (TypesForSequenceEdgeTarget == null) {
            TypesForSequenceEdgeTarget = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                String name = attype.getLiteral();
                if (name.startsWith("EventStart")) continue;
                IElementType elementType = "SubProcess".equals(name) ? BpmnElementTypes.SubProcess_2002 : BpmnElementTypes.Activity_2001;
                TypesForSequenceEdgeTarget.add(ElementTypeEx.wrap(elementType, name));
            }
            TypesForSequenceEdgeTarget.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_activity_label)));
            TypesForSequenceEdgeTarget.add(ElementTypeEx.wrap(BpmnElementTypes.SubProcess_2002, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_sub_process_label)));
        }
        return TypesForSequenceEdgeTarget;
    }

    public static Collection<IElementTypeEx> getElementTypesForMessagingEdgeTarget() {
        if (TypesForMessagingEdgeTarget == null) {
            TypesForMessagingEdgeTarget = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                String name = attype.getLiteral();
                if (name.startsWith("Gateway")) continue;
                switch (attype.getValue()) {
                    case 1: 
                    case 2: 
                    case 8: 
                    case 17: 
                    case 21: {
                        break;
                    }
                    default: {
                        TypesForMessagingEdgeTarget.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, name));
                    }
                }
            }
            TypesForMessagingEdgeTarget.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_activity_label)));
        }
        return TypesForMessagingEdgeTarget;
    }

    public static Collection<IElementTypeEx> getElementTypesForMessagingEdgeSource() {
        if (TypesForMessagingEdgeSource == null) {
            TypesForMessagingEdgeSource = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                String name = attype.getLiteral();
                if (name.startsWith("Gateway")) continue;
                switch (attype.getValue()) {
                    case 1: 
                    case 2: 
                    case 8: 
                    case 17: 
                    case 21: 
                    case 22: {
                        break;
                    }
                    default: {
                        TypesForMessagingEdgeSource.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, name));
                    }
                }
            }
            TypesForMessagingEdgeSource.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_activity_label)));
        }
        return TypesForMessagingEdgeSource;
    }

    public static Collection<IElementType> getElementTypesForAssociationTarget() {
        if (TypesForAssociationTarget == null) {
            TypesForAssociationTarget = new ArrayList<IElementType>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                if (attype.getValue() == 1) continue;
                TypesForAssociationTarget.add((IElementType)ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, attype.getName()));
            }
            TypesForAssociationTarget.add(BpmnElementTypes.SubProcess_2002);
            TypesForAssociationTarget.add((IElementType)ElementTypeEx.wrap(BpmnElementTypes.SubProcess_2002, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_sub_process_label)));
            TypesForAssociationTarget.add((IElementType)ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName(), BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BpmnPaletteFactory_looping_label, (Object)BpmnDiagramMessages.BPMNElementTypesActivities_activity_label)));
        }
        return TypesForAssociationTarget;
    }

    public static Collection<IElementType> getElementTypesForAssociationSource() {
        if (TypesForAssociationTargetSource == null) {
            TypesForAssociationTargetSource = new ArrayList<IElementType>();
            TypesForAssociationTargetSource.add(BpmnElementTypes.DataObject_1003);
            TypesForAssociationTargetSource.add(BpmnElementTypes.DataObject_2005);
            TypesForAssociationTargetSource.add(BpmnElementTypes.Group_1004);
            TypesForAssociationTargetSource.add(BpmnElementTypes.Group_2006);
            TypesForAssociationTargetSource.add(BpmnElementTypes.TextAnnotation_1002);
            TypesForAssociationTargetSource.add(BpmnElementTypes.TextAnnotation_2004);
        }
        return TypesForAssociationTargetSource;
    }
}

