/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.ui;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Handle;
import org.eclipse.gmf.runtime.diagram.ui.tools.AbstractPopupBarTool;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PopupBarLabelHandle
extends Label
implements Handle {
    private boolean myMouseOver = false;
    private Image myDisabledImage = null;
    private DragTracker myDragTracker = null;

    private Image getDisabledImage() {
        if (this.myDisabledImage != null) {
            return this.myDisabledImage;
        }
        Image theImage = this.getIcon();
        if (theImage == null) {
            return null;
        }
        this.myDisabledImage = new Image((Device)Display.getCurrent(), theImage, 1);
        return this.myDisabledImage;
    }

    public PopupBarLabelHandle(DragTracker tracker, Image theImage) {
        super(theImage);
        this.myDragTracker = tracker;
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.buttonLightest);
        this.calculateEnabled();
    }

    public Point getAccessibleLocation() {
        return null;
    }

    public DragTracker getDragTracker() {
        return this.myDragTracker;
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.myMouseOver) {
            Rectangle area = this.getClientArea();
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
        }
    }

    public void handleMouseEntered(MouseEvent event) {
        this.calculateEnabled();
        super.handleMouseEntered(event);
        this.myMouseOver = true;
        this.repaint();
    }

    public void handleMouseExited(MouseEvent event) {
        super.handleMouseExited(event);
        this.myMouseOver = false;
        this.repaint();
    }

    public void handleMousePressed(MouseEvent event) {
        int cfr_ignored_0 = event.button;
        super.handleMousePressed(event);
    }

    private void calculateEnabled() {
        if (this.myDragTracker != null && this.myDragTracker instanceof AbstractPopupBarTool) {
            AbstractPopupBarTool abarTool = (AbstractPopupBarTool)this.myDragTracker;
            this.setEnabled(abarTool.isCommandEnabled());
        } else {
            this.setEnabled(true);
        }
    }

    protected void paintFigure(Graphics graphics) {
        Image theImage;
        if (!this.isEnabled() && (theImage = this.getDisabledImage()) != null) {
            graphics.translate(this.bounds.x, this.bounds.y);
            graphics.drawImage(theImage, this.getIconLocation());
            graphics.translate(-this.bounds.x, -this.bounds.y);
            return;
        }
        super.paintFigure(graphics);
    }
}

