/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.AssociationTarget;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SequenceFlowConditionType;
import org.eclipse.stp.bpmn.commands.CreateRelationshipCommandEx;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.policies.BpmnBaseItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

public class SequenceEdgeItemSemanticEditPolicy
extends BpmnBaseItemSemanticEditPolicy {
    public static final String SEQUENCE_EDGE_FLOW_CONDITION_TYPE = "SEQUENCE_EDGE_FLOW_CONDITION_TYPE";
    public static final String FLOW_CONDITION_TYPE = "flow_condition_type_key";

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return this.getMSLWrapper((ICommand)new DestroyElementCommand(req));
    }

    protected Command getCreateCompleteIncomingAssociation3003Command(CreateRelationshipRequest req) {
        if (!(req.getSource() instanceof Artifact)) {
            return UnexecutableCommand.INSTANCE;
        }
        final Artifact element = (Artifact)this.getRelationshipContainer(req.getSource(), BpmnPackage.eINSTANCE.getArtifact(), req.getElementType());
        if (element == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (req.getContainmentFeature() == null) {
            req.setContainmentFeature(BpmnPackage.eINSTANCE.getArtifact_Associations());
        }
        for (Object tempA : element.getAssociations()) {
            if (!(tempA instanceof Association)) continue;
            Association association = (Association)tempA;
            if (!((IGraphicalEditPart)this.getHost()).resolveSemanticElement().equals(association.getTarget())) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return this.getMSLWrapper((ICommand)new CreateIncomingAssociation3003Command(req){

            protected EObject getElementToEdit() {
                return element;
            }
        });
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (BpmnElementTypes.Association_3003.getId().equals(req.getElementType().getId())) {
            return req.getTarget() == null ? null : this.getCreateCompleteIncomingAssociation3003Command(req);
        }
        return super.getCreateRelationshipCommand(req);
    }

    public boolean understandsRequest(Request request) {
        if (SEQUENCE_EDGE_FLOW_CONDITION_TYPE.equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public Command getCommand(Request request) {
        if (SEQUENCE_EDGE_FLOW_CONDITION_TYPE.equals(request.getType())) {
            int fct = (Integer)request.getExtendedData().get(FLOW_CONDITION_TYPE);
            SequenceEdge seqEdge = (SequenceEdge)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
            return this.getMSLWrapper((ICommand)new SetFlowConditionType(seqEdge, fct));
        }
        return super.getCommand(request);
    }

    private static class CreateIncomingAssociation3003Command
    extends CreateRelationshipCommandEx {
        public CreateIncomingAssociation3003Command(CreateRelationshipRequest req) {
            super(req);
        }

        protected EClass getEClassToEdit() {
            return BpmnPackage.eINSTANCE.getArtifact();
        }

        protected void setElementToEdit(EObject element) {
            throw new UnsupportedOperationException();
        }

        protected EObject doDefaultElementCreation() {
            Association newElement = (Association)super.doDefaultElementCreation();
            if (newElement != null) {
                newElement.setTarget((AssociationTarget)this.getTarget());
                newElement.setSource((Artifact)this.getSource());
            }
            return newElement;
        }
    }

    private class SetFlowConditionType
    extends AbstractTransactionalCommand {
        private int _flowConditionType;
        private SequenceEdge _sequenceEdge;

        public SetFlowConditionType(SequenceEdge sequenceEdge, int fct) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)sequenceEdge), BpmnDiagramMessages.SequenceEdgeItemSemanticEditPolicy_flow_condition_type_command, SetFlowConditionType.getWorkspaceFiles((EObject)sequenceEdge));
            this._flowConditionType = fct;
            this._sequenceEdge = sequenceEdge;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this._sequenceEdge.setConditionType(SequenceFlowConditionType.get((int)this._flowConditionType));
            return CommandResult.newOKCommandResult();
        }

        public boolean canExecute() {
            if (this._flowConditionType == this._sequenceEdge.getConditionType().getValue()) {
                return false;
            }
            boolean isDefault = false;
            boolean isConditional = false;
            boolean parallel = false;
            for (SequenceEdge e : this._sequenceEdge.getSource().getOutgoingEdges()) {
                if (e == this._sequenceEdge) continue;
                if (e.isIsDefault()) {
                    isDefault = true;
                    continue;
                }
                if (SequenceFlowConditionType.EXPRESSION_LITERAL.equals((Object)e.getConditionType())) {
                    isConditional = true;
                    continue;
                }
                if (!SequenceFlowConditionType.NONE_LITERAL.equals((Object)e.getConditionType())) continue;
                parallel = true;
            }
            int actype = ((Activity)this._sequenceEdge.getSource()).getActivityType().getValue();
            if (25 == actype || 27 == actype || 29 == actype) {
                isConditional = true;
                parallel = false;
            }
            if (this._flowConditionType == 2 && (isDefault || !isConditional)) {
                return false;
            }
            if (this._flowConditionType == 1 && ActivityType.VALUES_GATEWAYS.contains(((Activity)this._sequenceEdge.getSource()).getActivityType())) {
                return false;
            }
            return super.canExecute();
        }
    }
}

