/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.ui;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.figures.SubProcessFigure;
import org.eclipse.swt.graphics.Color;

public class RoundedSchemeBorder
extends AbstractBorder {
    public static final Insets INSETS = new Insets(0, 0, 4, 4);

    public void paint(IFigure fig, Graphics graphics, Insets insets) {
        int alpha = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getInt("bpmn.global.shadows.transparency");
        if (alpha <= 0) {
            return;
        }
        Color c = graphics.getBackgroundColor();
        int oriAlpha = graphics.getAlpha();
        graphics.setAlpha(alpha);
        graphics.setBackgroundColor(ColorConstants.black);
        this.fillShadow(fig, graphics, insets);
        graphics.setAlpha(oriAlpha);
        graphics.setBackgroundColor(c);
    }

    protected void fillShadow(IFigure fig, Graphics graphics, Insets insets) {
        Rectangle rect = null;
        rect = fig instanceof SubProcessFigure ? ((SubProcessFigure)fig).getHandleBounds().getCopy().translate(3, 3) : fig.getBounds().getCopy().translate(3, 3).resize(-4, -4);
        graphics.fillRoundRectangle(rect, 7, 7);
    }

    public Insets getInsets(IFigure figure) {
        return INSETS;
    }
}

