/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.gmf.runtime.draw2d.ui.text;

import java.util.List;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.draw2d.text.TextLayout;
import org.eclipse.stp.gmf.runtime.draw2d.ui.text.FlowUtilitiesEx;
import org.eclipse.stp.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.stp.gmf.runtime.draw2d.ui.text.TextUtilitiesEx;
import org.eclipse.swt.graphics.Font;

public class TruncatedSingleLineTextLayout
extends TextLayout {
    private String truncationString;

    public TruncatedSingleLineTextLayout(TextFlowEx flow, String truncationString) {
        super((TextFlow)flow);
        this.truncationString = truncationString;
    }

    protected String getTruncationString() {
        return this.truncationString;
    }

    private FlowUtilitiesEx getFlowUtilities() {
        return ((TextFlowEx)this.getFlowFigure()).getFlowUtilitiesHacked();
    }

    private TextUtilitiesEx getTextUtilities() {
        return ((TextFlowEx)this.getFlowFigure()).getTextUtilitiesHacked();
    }

    protected void layout() {
        TextFlow textFlow = (TextFlow)this.getFlowFigure();
        String text = textFlow.getText();
        List fragments = textFlow.getFragments();
        Font font = textFlow.getFont();
        int ellipsisWidth = this.getTextUtilities().getTextExtents((String)this.truncationString, (Font)font).width;
        TextFragmentBox fragment = this.getFragment(0, fragments);
        fragment.length = text.length();
        fragment.offset = 0;
        fragment.setWidth(-1);
        fragment.setTruncated(false);
        this.getFlowUtilities().setupFragmentEx(fragment, font, text);
        int remainingLineWidth = this.getContext().getRemainingLineWidth();
        if (remainingLineWidth > 0 && remainingLineWidth < fragment.getWidth()) {
            int subStringLength;
            fragment.length = (remainingLineWidth -= ellipsisWidth) > 0 ? (subStringLength = this.getTextUtilities().getLargestSubstringConfinedTo(text, font, remainingLineWidth)) : 0;
            fragment.setTruncated(true);
            fragment.setWidth(-1);
            this.getFlowUtilities().setupFragmentEx(fragment, font, text);
        } else {
            fragment.setTruncated(false);
        }
        this.getContext().addToCurrentLine((FlowBox)fragment);
        this.getContext().endLine();
        int i = 1;
        while (i < fragments.size()) {
            fragments.remove(i++);
        }
    }
}

