/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.file;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.stp.bpmn.diagram.actions.DeleteFileLinkAction;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditor;
import org.eclipse.stp.bpmn.validation.BpmnValidationMessages;
import org.eclipse.stp.bpmn.validation.quickfixes.AbstractBpmnMarkerResolution;
import org.eclipse.stp.bpmn.validation.quickfixes.IBpmnMarkerResolutionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExistenceContraintQuickfixProvider
implements IBpmnMarkerResolutionProvider {
    public static String ID = "FileExistenceContraintQuickfixProvider";
    static String MISSING_FILE_PROJ_RELATIVE_PATH_ATTRIBUTE = "missingFileProjectRelativePath";

    @Override
    public String getResolutionID() {
        return ID;
    }

    @Override
    public Collection<IMarkerResolution> getMarkerResolution(IMarker marker, String bpmnId, String elementId) {
        ArrayList<IMarkerResolution> r = new ArrayList<IMarkerResolution>(2);
        r.add((IMarkerResolution)new ChangeReferenceOfMissingFileResolution(marker));
        r.add((IMarkerResolution)new RemoveReferenceToMissingFileResolution(marker));
        return r;
    }

    private static String getMissingFileHandle(IMarker marker) {
        return marker.getAttribute(MISSING_FILE_PROJ_RELATIVE_PATH_ATTRIBUTE, null);
    }

    class ChangeReferenceOfMissingFileResolution
    extends AbstractBpmnMarkerResolution {
        private IMarker _marker;

        public ChangeReferenceOfMissingFileResolution(IMarker marker) {
            this._marker = marker;
        }

        public String getLabel() {
            return BpmnValidationMessages.bind((String)BpmnValidationMessages.FileExistenceContraintQuickfixProvider_change_reference, (Object)FileExistenceContraintQuickfixProvider.getMissingFileHandle(this._marker));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IMarker marker, IProgressMonitor monitor) {
            WorkbenchLabelProvider labelProv = null;
            WorkbenchContentProvider contentProv = null;
            try {
                BpmnDiagramEditor ed = super.openEditor(marker, monitor);
                if (ed == null) {
                    return;
                }
                labelProv = new WorkbenchLabelProvider();
                contentProv = new WorkbenchContentProvider();
                WorkspaceResourceDialog selectNewFile = new WorkspaceResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProv, (ITreeContentProvider)contentProv);
                selectNewFile.setAllowMultiple(false);
                selectNewFile.setInput((Object)marker.getResource().getProject());
                if (selectNewFile.open() != 0) {
                    return;
                }
                final IFile newFile = selectNewFile.getFile();
                DeleteFileLinkAction changeFileAttached = new DeleteFileLinkAction((IWorkbenchPart)ed){

                    public void doRun(IProgressMonitor progressMonitor) {
                        if (this.getSelectedElt() == null) {
                            return;
                        }
                        TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getSelectedElt());
                        RecordingCommand myCmd = new RecordingCommand(domain){

                            protected void doExecute() {
                                EcoreUtil.setAnnotation((EModelElement)this.getSelectedElt(), (String)this.getAnnotationSource(), (String)"projectRelativePath", (String)newFile.getProjectRelativePath().toString());
                                this.getSelectedPart().refresh();
                            }
                        };
                        domain.getCommandStack().execute((Command)myCmd);
                    }
                };
                changeFileAttached.refresh();
                changeFileAttached.setup();
                changeFileAttached.doRun(monitor);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                if (labelProv != null) {
                    labelProv.dispose();
                }
            }
        }

        public String getDescription() {
            return this.getLabel();
        }

        public Image getImage() {
            return null;
        }
    }

    class RemoveReferenceToMissingFileResolution
    extends AbstractBpmnMarkerResolution {
        private IMarker _marker;

        public RemoveReferenceToMissingFileResolution(IMarker marker) {
            this._marker = marker;
        }

        public String getLabel() {
            return BpmnValidationMessages.bind((String)BpmnValidationMessages.FileExistenceContraintQuickfixProvider_remove_reference, (Object)FileExistenceContraintQuickfixProvider.getMissingFileHandle(this._marker));
        }

        public void run(IMarker marker, IProgressMonitor monitor) {
            try {
                BpmnDiagramEditor ed = super.openEditor(marker, monitor);
                if (ed == null) {
                    return;
                }
                if (ed.navigateTo(null, this.getBpmnId(marker))) {
                    DeleteFileLinkAction del = new DeleteFileLinkAction((IWorkbenchPart)ed);
                    del.refresh();
                    del.setup();
                    del.doRun(monitor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String getDescription() {
            return this.getLabel();
        }

        public Image getImage() {
            return null;
        }
    }
}

