/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.part;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.editor.FileDiagramEditor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnEditPartFactory;
import org.eclipse.stp.bpmn.diagram.part.BpmnCreationWizardPage;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditDomain;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.stp.bpmn.diagram.part.BpmnDocumentProvider;
import org.eclipse.stp.bpmn.diagram.providers.BpmnMarkerNavigationProvider;
import org.eclipse.stp.bpmn.diagram.providers.QuickfixResolutionMenuManager;
import org.eclipse.stp.bpmn.dnd.BpmnDropTargetListener;
import org.eclipse.stp.bpmn.menu.internal.ProxiedBpmnDiagramContextMenuListener;
import org.eclipse.stp.bpmn.palette.BpmnPaletteViewer;
import org.eclipse.stp.bpmn.provider.ActivityItemProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.IGotoMarker;

public class BpmnDiagramEditor
extends FileDiagramEditor
implements IGotoMarker {
    public static final String ID = "org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorID";
    private PreferenceStoreListener _prefListener;

    public BpmnDiagramEditor() {
        super(true);
    }

    protected String getEditingDomainID() {
        return "org.eclipse.stp.bpmn.diagram.EditingDomain";
    }

    protected TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain domain = super.createEditingDomain();
        domain.setID(this.getEditingDomainID());
        return domain;
    }

    protected void setDocumentProvider(IEditorInput input) {
        IFile fileInput = (IFile)input.getAdapter(IFile.class);
        if (fileInput != null) {
            this.setDocumentProvider((IDocumentProvider)new BpmnDocumentProvider());
            this.setupBpmnValidationBuildAbleNature((IResource)fileInput);
        } else {
            this.setDocumentProvider((IDocumentProvider)new StorageDiagramDocumentProvider());
        }
    }

    protected void setupBpmnValidationBuildAbleNature(IResource fileInput) {
        BpmnCreationWizardPage.setupBpmnValidationBuildableNature(fileInput.getFullPath(), "org.eclipse.stp.bpmn.validation.BatchValidationBuildAbleNature", "org.eclipse.stp.bpmn.validation.BatchValidationBuilder");
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getContextMenu().addMenuListener((IMenuListener)new QuickfixResolutionMenuManager(this.getGraphicalViewer()));
        this.getGraphicalViewer().getContextMenu().addMenuListener((IMenuListener)new BpmnContextMenuProvider());
        DiagramRootEditPart root = (DiagramRootEditPart)this.getDiagramGraphicalViewer().getRootEditPart();
        BpmnEditPartFactory.setupConnectionLayerExEx(root);
        this.setupSnapToGeometry(root);
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new BpmnDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
    }

    protected void createDiagramEditDomain() {
        BpmnDiagramEditDomain editDomain = new BpmnDiagramEditDomain((DiagramEditor)this);
        editDomain.setActionManager(this.createActionManager());
        this.setEditDomain((DefaultEditDomain)editDomain);
    }

    private void setupSnapToGeometry(DiagramRootEditPart root) {
        boolean enableSnapToGeometry = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(BpmnDiagramPreferenceInitializer.PREF_SNAP_TO_GEOMETRY);
        root.getViewer().setProperty("SnapToGeometry.isEnabled", (Object)enableSnapToGeometry);
        if (this._prefListener != null) {
            this._prefListener.dispose();
        }
        this._prefListener = new PreferenceStoreListener(root);
    }

    public void dispose() {
        if (this._prefListener != null) {
            this._prefListener.dispose();
        }
        super.dispose();
    }

    protected PreferencesHint getPreferencesHint() {
        return new PreferencesHint("org.eclipse.stp.bpmn.diagram");
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        this.getEditDomain().setPaletteRoot(this.createPaletteRoot(null));
        return BpmnPaletteViewer.getBpmnPaletteViewerProvider((EditDomain)this.getEditDomain());
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public boolean navigateTo(String gmfElementId, String bpmnId) {
        return BpmnMarkerNavigationProvider.navigateTo((DiagramEditor)this, gmfElementId, bpmnId);
    }

    private class BpmnContextMenuProvider
    implements IMenuListener {
        private BpmnContextMenuProvider() {
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            List<ProxiedBpmnDiagramContextMenuListener> menuListeners = BpmnDiagramEditorPlugin.getInstance().getContextMenuListeners(BpmnDiagramEditor.this.getEditorSite().getId());
            if (menuListeners == null) {
                return;
            }
            for (ProxiedBpmnDiagramContextMenuListener listener : menuListeners) {
                listener.menuAboutToShow(menuManager, BpmnDiagramEditor.this);
            }
        }
    }

    private class PreferenceStoreListener
    implements IPropertyChangeListener {
        private final DiagramRootEditPart _root;
        private final IPreferenceStore _prefStore;

        PreferenceStoreListener(DiagramRootEditPart root) {
            this._root = root;
            this._prefStore = (IPreferenceStore)root.getPreferencesHint().getPreferenceStore();
            this._prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (BpmnDiagramPreferenceInitializer.PREF_SNAP_TO_GEOMETRY.equals(event.getProperty())) {
                this._root.getViewer().setProperty("SnapToGeometry.isEnabled", event.getNewValue());
            } else if (event.getProperty().equals(BpmnDiagramPreferenceInitializer.PREF_SEQ_LINE_ALPHA) || event.getProperty().equals(BpmnDiagramPreferenceInitializer.PREF_MSG_LINE_ALPHA)) {
                IFigure connLayer = this._root.getLayer((Object)"Connection Layer");
                if (connLayer != null) {
                    connLayer.repaint();
                }
            } else if (event.getProperty().equals("bpmn.1.1.style")) {
                ActivityItemProvider.IS_BPMN_11_STYLE = "true".equals(String.valueOf(event.getNewValue()));
            }
        }

        public void dispose() {
            this._prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }
}

