/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.core.util.IProxyEObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.commands.IElementTypeEx;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.dnd.ISecondarySemanticHintProcessor;
import org.eclipse.swt.graphics.Image;

public class BpmnElementTypes {
    private static Map<String, EClass> elements;
    private static ImageRegistry imageRegistry;
    private static final Map<String, IHintedType> BpmnElementTypesIndexedBySemanticHint;
    public static final IElementType BpmnDiagram_79;
    public static final IElementType Activity_2001;
    public static final IElementType SubProcess_2002;
    public static final IElementType Activity_2003;
    public static final IElementType TextAnnotation_2004;
    public static final IElementType DataObject_2005;
    public static final IElementType Group_2006;
    public static final IElementType Lane_2007;
    public static final IElementType Pool_1001;
    public static final IElementType TextAnnotation_1002;
    public static final IElementType DataObject_1003;
    public static final IElementType Group_1004;
    public static final IElementType SequenceEdge_3001;
    public static final IElementType MessagingEdge_3002;
    public static final IElementType Association_3003;
    private static Set KNOWN_ELEMENT_TYPES;

    static {
        BpmnElementTypesIndexedBySemanticHint = new HashMap<String, IHintedType>();
        BpmnDiagram_79 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.BpmnDiagram_79");
        Activity_2001 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.Activity_2001");
        SubProcess_2002 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.SubProcess_2002");
        Activity_2003 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.Activity_2003");
        TextAnnotation_2004 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.TextAnnotation_2004");
        DataObject_2005 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.DataObject_2005");
        Group_2006 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.Group_2006");
        Lane_2007 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.Lane_2007");
        Pool_1001 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.Pool_1001");
        TextAnnotation_1002 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.TextAnnotation_1002");
        DataObject_1003 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.DataObject_1003");
        Group_1004 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.Group_1004");
        SequenceEdge_3001 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.SequenceEdge_3001");
        MessagingEdge_3002 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.MessagingEdge_3002");
        Association_3003 = BpmnElementTypes.getElementType("org.eclipse.stp.bpmn.diagram.Association_3003");
    }

    private BpmnElementTypes() {
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static String getImageRegistryKey(ENamedElement element) {
        return element.getName();
    }

    private static ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            element = ((EStructuralFeature)element).getEContainingClass();
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            return BpmnDiagramEditorPlugin.getInstance().getItemImageDescriptor(eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element) {
        String key = BpmnElementTypes.getImageRegistryKey(element);
        ImageDescriptor imageDescriptor = BpmnElementTypes.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = BpmnElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            BpmnElementTypes.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(ENamedElement element) {
        String key = BpmnElementTypes.getImageRegistryKey(element);
        Image image = BpmnElementTypes.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = BpmnElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            BpmnElementTypes.getImageRegistry().put(key, imageDescriptor);
            image = BpmnElementTypes.getImageRegistry().get(key);
        }
        return image;
    }

    private static String getImageRegistryKey(ENamedElement element, String activityType) {
        return String.valueOf(element.getName()) + "." + activityType;
    }

    private static ImageDescriptor getProvidedImageDescriptor(ENamedElement element, String activityString) {
        if (element instanceof EStructuralFeature) {
            element = ((EStructuralFeature)element).getEContainingClass();
        }
        if (element instanceof EClass) {
            for (ISecondarySemanticHintProcessor sec : BpmnDiagramEditorPlugin.getInstance().getSecondarySemanticHintParsers()) {
                ImageDescriptor imgDesc = sec.getImageDescriptorForTool(element, activityString);
                if (imgDesc == null) continue;
                return imgDesc;
            }
            EClass eClass = (EClass)element;
            if (!eClass.isAbstract()) {
                EObject eo = eClass.getEPackage().getEFactoryInstance().create(eClass);
                if (eo instanceof Activity && activityString != null) {
                    ActivityType at = ActivityType.get((String)activityString);
                    if (at != null) {
                        ((Activity)eo).setActivityType(at);
                    } else if ("looping".equals(activityString)) {
                        ((Activity)eo).setLooping(true);
                    }
                }
                return BpmnDiagramEditorPlugin.getInstance().getItemImageDescriptor(eo);
            }
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element, String activityType) {
        for (ISecondarySemanticHintProcessor sec : BpmnDiagramEditorPlugin.getInstance().getSecondarySemanticHintParsers()) {
            ImageDescriptor imgDesc = sec.getImageDescriptorForTool(element, activityType);
            if (imgDesc == null) continue;
            return imgDesc;
        }
        String key = BpmnElementTypes.getImageRegistryKey(element, activityType);
        ImageDescriptor imageDescriptor = BpmnElementTypes.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = BpmnElementTypes.getProvidedImageDescriptor(element, activityType);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            BpmnElementTypes.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(ENamedElement element, String activityString) {
        for (ISecondarySemanticHintProcessor sec : BpmnDiagramEditorPlugin.getInstance().getSecondarySemanticHintParsers()) {
            Image img = sec.getImageForTool(element, activityString);
            if (img == null) continue;
            return img;
        }
        String key = BpmnElementTypes.getImageRegistryKey(element, activityString);
        Image image = BpmnElementTypes.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = BpmnElementTypes.getProvidedImageDescriptor(element, activityString);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            BpmnElementTypes.getImageRegistry().put(key, imageDescriptor);
            image = BpmnElementTypes.getImageRegistry().get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
        String activityString;
        ENamedElement element = BpmnElementTypes.getElement(hint);
        String string = activityString = hint instanceof IElementTypeEx ? ((IElementTypeEx)hint).getSecondarySemanticHint() : null;
        if (element == null) {
            return null;
        }
        return BpmnElementTypes.getImageDescriptor(element, activityString);
    }

    public static Image getImage(IAdaptable hint) {
        String activityString = hint instanceof IElementTypeEx ? ((IElementTypeEx)hint).getSecondarySemanticHint() : null;
        ENamedElement element = BpmnElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return BpmnElementTypes.getImage(element, activityString);
    }

    public static ENamedElement getElement(IAdaptable hint) {
        IElementType type;
        if (hint instanceof IProxyEObject) {
            EObject oo = ((IProxyEObject)hint).resolve();
            if (oo instanceof BpmnDiagram) {
                hint = BpmnDiagram_79;
            } else if (oo instanceof IAdaptable) {
                hint = (IAdaptable)oo;
            }
        }
        IElementType iElementType = type = hint instanceof IElementType ? (IElementType)hint : (IElementType)hint.getAdapter(IElementType.class);
        if (elements == null) {
            elements = new HashMap<String, EClass>();
            elements.put(BpmnDiagram_79.getId(), BpmnPackage.eINSTANCE.getBpmnDiagram());
            elements.put(Activity_2001.getId(), BpmnPackage.eINSTANCE.getActivity());
            elements.put(SubProcess_2002.getId(), BpmnPackage.eINSTANCE.getSubProcess());
            elements.put(Activity_2003.getId(), BpmnPackage.eINSTANCE.getActivity());
            elements.put(TextAnnotation_2004.getId(), BpmnPackage.eINSTANCE.getTextAnnotation());
            elements.put(DataObject_2005.getId(), BpmnPackage.eINSTANCE.getDataObject());
            elements.put(Group_2006.getId(), BpmnPackage.eINSTANCE.getGroup());
            elements.put(Lane_2007.getId(), BpmnPackage.eINSTANCE.getLane());
            elements.put(Pool_1001.getId(), BpmnPackage.eINSTANCE.getPool());
            elements.put(TextAnnotation_1002.getId(), BpmnPackage.eINSTANCE.getTextAnnotation());
            elements.put(DataObject_1003.getId(), BpmnPackage.eINSTANCE.getDataObject());
            elements.put(Group_1004.getId(), BpmnPackage.eINSTANCE.getGroup());
            elements.put(SequenceEdge_3001.getId(), BpmnPackage.eINSTANCE.getSequenceEdge());
            elements.put(MessagingEdge_3002.getId(), BpmnPackage.eINSTANCE.getMessagingEdge());
            elements.put(Association_3003.getId(), BpmnPackage.eINSTANCE.getAssociation());
        }
        if (type != null) {
            return (ENamedElement)elements.get(type.getId());
        }
        return null;
    }

    private static IElementType getElementType(String id) {
        IElementType et = ElementTypeRegistry.getInstance().getType(id);
        if (et != null && et instanceof IHintedType) {
            IHintedType het = (IHintedType)et;
            BpmnElementTypesIndexedBySemanticHint.put(het.getSemanticHint(), het);
        }
        return et;
    }

    public static IHintedType getBpmnElementType(String semanticHint) {
        return BpmnElementTypesIndexedBySemanticHint.get(semanticHint);
    }

    public static boolean isKnownElementType(IElementType elementType) {
        if (elements == null) {
            return BpmnElementTypes.getElement((IAdaptable)elementType) != null;
        }
        return elements.containsKey(elementType.getId());
    }
}

