/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenFileEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        EObject object;
        if (request instanceof SelectionRequest) {
            return null;
        }
        EditPart part = this.getTargetEditPart(request);
        if (part == null) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        if (part instanceof IGraphicalEditPart && (object = ((IGraphicalEditPart)part).getNotationView().getElement()) instanceof EModelElement) {
            return this.getOpenCommand(request, (IGraphicalEditPart)part, (EModelElement)object, page);
        }
        return null;
    }

    protected Command getOpenCommand(Request request, IGraphicalEditPart part, EModelElement model, IWorkbenchPage page) {
        EAnnotation ann = model.getEAnnotation("genericFile");
        if (ann == null) {
            return null;
        }
        String filePath = (String)ann.getDetails().get((Object)"projectRelativePath");
        String line = (String)ann.getDetails().get((Object)"lineNumber");
        IFile ourFile = WorkspaceSynchronizer.getFile((Resource)model.eResource()).getProject().getFile(filePath);
        return this.getOpenCommand(ourFile, line, page, null);
    }

    protected Command getOpenCommand(final IFile fileToOpen, Object line, final IWorkbenchPage page, Map<String, Object> otherOptionalGotoMarkerAttributes) {
        InMemoryMarker marker = null;
        if (line != null || otherOptionalGotoMarkerAttributes != null) {
            try {
                if (otherOptionalGotoMarkerAttributes == null) {
                    otherOptionalGotoMarkerAttributes = new HashMap<String, Object>();
                }
                marker = new InMemoryMarker((IResource)fileToOpen, "org.eclipse.stp.bpmn.validation.diagnostic");
                otherOptionalGotoMarkerAttributes.put("transient", true);
                if (line != null) {
                    otherOptionalGotoMarkerAttributes.put("lineNumber", line instanceof Integer ? ((Integer)line).intValue() : Integer.valueOf((String)line).intValue());
                }
                marker.setAttributes(otherOptionalGotoMarkerAttributes);
            }
            catch (CoreException e1) {
                marker = null;
            }
            catch (NumberFormatException e2) {
                marker = null;
            }
        }
        if (marker == null) {
            Command co = new Command(BpmnDiagramMessages.OpenFileEditPolicy_command_name){

                public void execute() {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)fileToOpen);
                    }
                    catch (PartInitException e) {
                        BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, e.getMessage(), (Throwable)e));
                    }
                }
            };
            return co;
        }
        final InMemoryMarker finalMarker = marker;
        Command co = new Command(BpmnDiagramMessages.bind((String)BpmnDiagramMessages.OpenFileEditPolicy_command_name_with_line, (Object)line)){

            public void execute() {
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IMarker)finalMarker);
                }
                catch (PartInitException e) {
                    BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, e.getMessage(), (Throwable)e));
                }
            }
        };
        return co;
    }

    private static class InMemoryMarker
    implements IMarker {
        private long creationTime = System.currentTimeMillis();
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private IResource resource;
        private String type;

        public InMemoryMarker(IResource resource) {
            this(resource, "yo");
        }

        public InMemoryMarker(IResource resource, String type) {
            assert (resource != null);
            this.resource = resource;
            this.type = type;
        }

        public void delete() throws CoreException {
        }

        public boolean exists() {
            return true;
        }

        public Object getAttribute(String attributeName) throws CoreException {
            return this.attributes.get(attributeName);
        }

        public int getAttribute(String attributeName, int defaultValue) {
            Integer intAttribute = (Integer)this.attributes.get(attributeName);
            return intAttribute != null ? intAttribute : defaultValue;
        }

        public String getAttribute(String attributeName, String defaultValue) {
            Object objVal = this.attributes.get(attributeName);
            return objVal != null ? objVal.toString() : defaultValue;
        }

        public boolean getAttribute(String attributeName, boolean defaultValue) {
            Boolean boolAttribute = (Boolean)this.attributes.get(attributeName);
            return boolAttribute != null ? boolAttribute : defaultValue;
        }

        public Map getAttributes() throws CoreException {
            return this.attributes;
        }

        public Object[] getAttributes(String[] attributeNames) throws CoreException {
            ArrayList<Object> values = new ArrayList<Object>();
            int i = 0;
            while (i < attributeNames.length) {
                Object val = this.attributes.get(attributeNames[i]);
                if (val != null) {
                    values.add(val);
                }
                ++i;
            }
            return values.toArray(new Object[values.size()]);
        }

        public long getCreationTime() throws CoreException {
            return this.creationTime;
        }

        public long getId() {
            return this.creationTime;
        }

        public IResource getResource() {
            return this.resource;
        }

        public String getType() throws CoreException {
            return this.type;
        }

        public boolean isSubtypeOf(String superType) throws CoreException {
            return false;
        }

        public void setAttribute(String attributeName, int value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttribute(String attributeName, Object value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttribute(String attributeName, boolean value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        }

        public void setAttributes(Map attributes) throws CoreException {
            this.attributes = attributes;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

