/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Group;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.policies.ResizableArtifactEditPolicy;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;
import org.eclipse.stp.bpmn.tools.GroupDragTracker;
import org.eclipse.stp.bpmn.tools.GroupResizeTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizableGroupEditPolicy
extends ResizableArtifactEditPolicy {
    @Override
    protected Handle createHandle(GraphicalEditPart owner, int direction) {
        return new GroupResizeHandle(owner, direction);
    }

    @Override
    protected void replaceHandleDragEditPartsTracker(Handle handle) {
        if (handle instanceof AbstractHandle) {
            AbstractHandle h = (AbstractHandle)handle;
            h.setDragTracker((DragTracker)new GroupDragTracker((IGraphicalEditPart)this.getHost()));
        }
    }

    private List<Activity> findContainedActivities(ChangeBoundsRequest request) {
        Rectangle rect = ((IGraphicalEditPart)this.getHost()).getFigure().getBounds().getCopy();
        ((IGraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (Object fig : this.getHost().getViewer().getVisualPartMap().keySet()) {
            Object part = this.getHost().getViewer().getVisualPartMap().get(fig);
            if (!(part instanceof ActivityEditPart) && !(part instanceof Activity2EditPart) && !(part instanceof SubProcessEditPart)) continue;
            Rectangle bounds = ((IGraphicalEditPart)part).getFigure().getBounds().getCopy();
            ((IGraphicalEditPart)part).getFigure().translateToAbsolute((Translatable)bounds);
            if (!rect.contains(bounds)) continue;
            activities.add((Activity)((IGraphicalEditPart)part).resolveSemanticElement());
        }
        return activities;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        CompoundCommand compound = new CompoundCommand();
        compound.add(super.getResizeCommand(request));
        List<Activity> activities = this.findContainedActivities(request);
        SetActivitiesCommand command = new SetActivitiesCommand((Group)((IGraphicalEditPart)this.getHost()).resolveSemanticElement(), activities);
        compound.add((Command)new ICommandProxy((ICommand)command));
        return compound;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        CompoundCommand compound = new CompoundCommand();
        compound.add(super.getMoveCommand(request));
        List<Activity> activities = this.findContainedActivities(request);
        SetActivitiesCommand command = new SetActivitiesCommand((Group)((IGraphicalEditPart)this.getHost()).resolveSemanticElement(), activities);
        compound.add((Command)new ICommandProxy((ICommand)command));
        return compound;
    }

    protected static class GroupResizeHandle
    extends ResizableShapeEditPolicyEx.ResizeHandleEx {
        public GroupResizeHandle(GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        protected DragTracker createDragTracker() {
            return new GroupResizeTracker(this.getOwner(), this.cursorDirection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetActivitiesCommand
    extends AbstractTransactionalCommand {
        private Group _group;
        private List<Activity> _activities;

        public SetActivitiesCommand(Group elt, List<Activity> activities) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)elt), BpmnDiagramMessages.ResizableGroupEditPolicy_command_name, SetActivitiesCommand.getWorkspaceFiles((EObject)elt));
            this._group = elt;
            this._activities = activities;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ArrayList<Activity> toRemove = new ArrayList<Activity>();
            ArrayList<Activity> activities = new ArrayList<Activity>(this._activities);
            for (Activity a : this._group.getActivities()) {
                if (activities.remove(a)) continue;
                toRemove.add(a);
            }
            this._group.getActivities().removeAll(toRemove);
            this._group.getActivities().addAll(activities);
            return CommandResult.newOKCommandResult();
        }
    }
}

