/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SequenceFlowConditionType;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.validation.BpmnValidationMessages;

public class ControlledFlowsConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        SequenceEdge edge = (SequenceEdge)ctx.getTarget();
        if (edge.getSource() == null) {
            return ctx.createSuccessStatus();
        }
        boolean moreThanOneEdgeOut = edge.getSource().getOutgoingEdges().size() > 1;
        boolean atLeastOneConditional = false;
        boolean atLeastOneParallel = false;
        for (SequenceEdge e : edge.getSource().getOutgoingEdges()) {
            atLeastOneConditional |= e.getConditionType() == SequenceFlowConditionType.EXPRESSION_LITERAL;
            atLeastOneParallel |= e.getConditionType() == SequenceFlowConditionType.NONE_LITERAL;
        }
        int actype = ((Activity)edge.getSource()).getActivityType().getValue();
        if (25 == actype || 27 == actype || 29 == actype) {
            atLeastOneConditional = moreThanOneEdgeOut;
            atLeastOneParallel = false;
        }
        switch (edge.getConditionType().getValue()) {
            case 2: {
                if (!moreThanOneEdgeOut) {
                    return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.ControlledFlowsConstraint_default_and_no_other_edges});
                }
                if (!atLeastOneConditional) {
                    return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.ControlledFlowsConstraint_default_and_no_controlled_flows});
                }
                if (!atLeastOneParallel) break;
                return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.ControlledFlowsConstraint_default_never_executed});
            }
            case 1: {
                ActivityType type;
                if (!moreThanOneEdgeOut) {
                    return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.ControlledFlowsConstraint_unique_conditional_edge});
                }
                Vertex src = edge.getSource();
                if (src == null || !(src instanceof Activity) || !ActivityType.VALUES_GATEWAYS.contains(type = ((Activity)src).getActivityType())) break;
                return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.ControlledFlowsConstraint_unique_conditional_flow});
            }
        }
        return ctx.createSuccessStatus();
    }
}

