/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.stp.bpmn.figures.FilledPolylineDecoration;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;

public class MessagePolylineTargetDecoration
extends FilledPolylineDecoration {
    private static final PointList MSG_TRIANGLE_TIP_ROUND_STYLE = new PointList();
    private static final PointList MSG_TRIANGLE_TIP_TASK_STYLE = new PointList();
    private static double scaleX;
    private static double scaleY;
    private boolean _styleIsRound;
    private boolean _currTplIsRound;

    static {
        MSG_TRIANGLE_TIP_TASK_STYLE.addPoint(-3, 2);
        MSG_TRIANGLE_TIP_TASK_STYLE.addPoint(0, 0);
        MSG_TRIANGLE_TIP_TASK_STYLE.addPoint(-3, -2);
        MSG_TRIANGLE_TIP_TASK_STYLE.addPoint(-3, 2);
        scaleX = 2.0;
        scaleY = 2.0;
        MSG_TRIANGLE_TIP_ROUND_STYLE.addPoint(-2, 2);
        MSG_TRIANGLE_TIP_ROUND_STYLE.addPoint(1, 0);
        MSG_TRIANGLE_TIP_ROUND_STYLE.addPoint(-2, -2);
        MSG_TRIANGLE_TIP_ROUND_STYLE.addPoint(-2, 2);
        MSG_TRIANGLE_TIP_ROUND_STYLE.translate(1, 0);
    }

    public MessagePolylineTargetDecoration(boolean isRoundStyle) {
        this.setFillXOR(true);
        this.setBackgroundColor(ColorConstants.white);
        this.setForegroundColor(ColorConstants.black);
        this.setScale(scaleX, scaleY);
        this._styleIsRound = isRoundStyle;
        this._currTplIsRound = !this._styleIsRound;
        this.updateStyle();
    }

    public void setStyle(boolean isRoundStyle) {
        this._styleIsRound = isRoundStyle;
        this.updateStyle();
    }

    private void updateStyle() {
        if (this._styleIsRound != this._currTplIsRound) {
            if (this._styleIsRound) {
                this.setTemplate(MSG_TRIANGLE_TIP_ROUND_STYLE);
            } else {
                this.setTemplate(MSG_TRIANGLE_TIP_TASK_STYLE);
            }
        }
    }

    public void setTemplate(PointList pl) {
        this._currTplIsRound = pl == MSG_TRIANGLE_TIP_ROUND_STYLE;
        super.setTemplate(pl);
    }

    protected void outlineShape(Graphics graphics) {
        int alpha = graphics.getAlpha();
        graphics.setAlpha(ActivityPainter.getMessagingEdgeTransparency());
        super.outlineShape(graphics);
        graphics.setAlpha(alpha);
    }
}

