/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;

public class ConnectionEndPointEditPolicyEx
extends ConnectionEndpointEditPolicy {
    protected List createSelectionHandles() {
        ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>();
        list.add(new ConnectionEndHandleEx((ConnectionEditPart)this.getHost()));
        list.add(new ConnectionStartHandleEx((ConnectionEditPart)this.getHost()));
        return list;
    }

    private class ConnectionEndHandleEx
    extends ConnectionHandle {
        public ConnectionEndHandleEx(ConnectionEditPart owner) {
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 3));
        }

        public ConnectionEndHandleEx(ConnectionEditPart owner, boolean fixed) {
            super(fixed);
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 3));
        }

        public ConnectionEndHandleEx() {
        }

        protected DragTracker createDragTracker() {
            if (this.isFixed()) {
                return null;
            }
            ConnectionEndpointTrackerEx tracker = new ConnectionEndpointTrackerEx((ConnectionEditPart)this.getOwner());
            tracker.setCommandName("Reconnection target");
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }

    private class ConnectionEndpointTrackerEx
    extends ConnectionEndpointTracker {
        public ConnectionEndpointTrackerEx(ConnectionEditPart cep) {
            super(cep);
        }

        protected boolean updateTargetUnderMouse() {
            if (!this.isTargetLocked()) {
                EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
                if (this.getConnectionEditPart() instanceof SequenceEdgeEditPart) {
                    IGraphicalEditPart newT;
                    Vertex target;
                    Graph g = ((SequenceEdge)((SequenceEdgeEditPart)this.getConnectionEditPart()).resolveSemanticElement()).getGraph();
                    if (editPart instanceof IGraphicalEditPart && !(((IGraphicalEditPart)editPart).resolveSemanticElement() instanceof Vertex)) {
                        int offset = MapModeUtil.getMapMode((IFigure)this.getConnection()).LPtoDP(20);
                        editPart = this.getConnectionEditPart().getViewer().findObjectAt(this.getCurrentInput().getMouseLocation().getCopy().getTranslated(0, offset));
                        if (editPart instanceof IGraphicalEditPart && !(((IGraphicalEditPart)editPart).resolveSemanticElement() instanceof Vertex)) {
                            editPart = this.getConnectionEditPart().getViewer().findObjectAt(this.getCurrentInput().getMouseLocation().getCopy().getTranslated(0, -offset));
                        }
                    }
                    if (editPart instanceof IGraphicalEditPart && ((IGraphicalEditPart)editPart).resolveSemanticElement() instanceof Vertex && !(target = (Vertex)((IGraphicalEditPart)editPart).resolveSemanticElement()).getGraph().equals(g) && (newT = this.findParentTarget(super.getTargetEditPart(), g)) != null) {
                        editPart = newT;
                    }
                }
                if (editPart != null) {
                    editPart = editPart.getTargetEditPart(this.getTargetRequest());
                }
                boolean changed = this.getTargetEditPart() != editPart;
                this.setTargetEditPart(editPart);
                return changed;
            }
            return false;
        }

        private IGraphicalEditPart findParentTarget(EditPart currentTarget, Graph toComplyWith) {
            if (!(currentTarget instanceof IGraphicalEditPart)) {
                return null;
            }
            if (currentTarget instanceof SubProcessEditPart && toComplyWith.equals(((Vertex)((IGraphicalEditPart)currentTarget).resolveSemanticElement()).getGraph())) {
                return (IGraphicalEditPart)currentTarget;
            }
            return this.findParentTarget(currentTarget.getParent(), toComplyWith);
        }

        protected Command getCommand() {
            Command co = super.getCommand();
            return co;
        }
    }

    private class ConnectionStartHandleEx
    extends ConnectionHandle {
        public ConnectionStartHandleEx(ConnectionEditPart owner) {
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 2));
        }

        public ConnectionStartHandleEx(ConnectionEditPart owner, boolean fixed) {
            super(fixed);
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 2));
        }

        public ConnectionStartHandleEx() {
        }

        protected DragTracker createDragTracker() {
            if (this.isFixed()) {
                return null;
            }
            ConnectionEndpointTrackerEx tracker = new ConnectionEndpointTrackerEx((ConnectionEditPart)this.getOwner());
            tracker.setCommandName("Reconnection source");
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }
}

