/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.GravityConstrainedFlowLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.GravityDirectionType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.PoolCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.PoolGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.PoolItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.VerticalLabel;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.DelegateToCompartmentEditPolicy;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;
import org.eclipse.stp.bpmn.policies.ResizablePoolEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class PoolEditPart
extends ShapeNodeEditPart {
    public static final int POOL_HEIGHT = 200;
    public static final int POOL_HEIGHT_COLLAPSED = 32;
    public static final int POOL_WIDTH = 1500;
    public static final int VISUAL_ID = 1001;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    public static final Color POOLNAMEFIGURE_BACK = new Color(null, 227, 235, 251);
    public static final Color POOLFIGURE_BACK = new Color(null, 232, 232, 255);
    public static final Color BORDER = new Color(null, 169, 169, 169);

    public PoolEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new PoolItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new PoolGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new PoolCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new ConnectionHandleEditPolicyEx());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new DelegateToCompartmentEditPolicy(BpmnVisualIDRegistry.getType(5001), "ContainerEditPolicy"));
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)this.createOpenFileEditPolicy());
    }

    protected OpenFileEditPolicy createOpenFileEditPolicy() {
        return new OpenFileEditPolicy();
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        PoolFigure figure = new PoolFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public PoolFigure getPrimaryShape() {
        return (PoolFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof PoolNameEditPart) {
            ((PoolNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigurePoolNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected NodeFigure createNodePlate() {
        Rectangle parentBounds = ((GraphicalEditPart)this.getParent()).getFigure().getBounds();
        return new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(parentBounds.width - 25), this.getMapMode().DPtoLP(200)){

            public void setBackgroundColor(Color bg) {
                List children = this.getChildren();
                for (Object object : children) {
                    ((IFigure)object).setBackgroundColor(bg);
                }
                super.setBackgroundColor(bg);
            }
        };
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            GravityConstrainedFlowLayout layout = new GravityConstrainedFlowLayout();
            layout.setGravity(GravityDirectionType.WEST);
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4008));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    public boolean isPoolBodyCompartmentCollapsed() {
        IGraphicalEditPart poolCompartment = this.getChildBySemanticHint(Integer.toString(5001));
        return poolCompartment != null && (Boolean)poolCompartment.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed()) != false;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizablePoolEditPolicy();
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            return FigureUtilities.RGBToInteger((RGB)POOLFIGURE_BACK.getRGB());
        }
        return super.getPreferredValue(feature);
    }

    public class PoolFigure
    extends RectangleFigure {
        private VerticalLabel fPoolNameFigure;
        private boolean myUseLocalCoordinates = false;

        public PoolFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.setBackgroundColor(POOLFIGURE_BACK);
            this.setBorder((Border)new LineBorder(BORDER));
            this.createContents();
        }

        protected void createContents() {
            boolean isCollapsed = PoolEditPart.this.isPoolBodyCompartmentCollapsed();
            VerticalLabel fig_0 = new VerticalLabel(!isCollapsed){

                public Rectangle getBounds() {
                    Rectangle bounds = super.getBounds();
                    IFigure parentFigure = this.getParent();
                    if (parentFigure != null) {
                        List children = this.getParent().getChildren();
                        IFigure poolCompartmentFigure = null;
                        for (Object child : children) {
                            if (!(child instanceof ResizableCompartmentFigure)) continue;
                            poolCompartmentFigure = (IFigure)child;
                            break;
                        }
                        if (poolCompartmentFigure != null) {
                            Rectangle parentBounds = parentFigure.getBounds();
                            bounds.x = (poolCompartmentFigure.getBounds().x - bounds.width) / 2 + parentBounds.x;
                        }
                    }
                    return bounds;
                }
            };
            fig_0.setTextWrap(true);
            fig_0.setBackgroundColor(POOLNAMEFIGURE_BACK);
            this.setFigurePoolNameFigure(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
        }

        public VerticalLabel getFigurePoolNameFigure() {
            return this.fPoolNameFigure;
        }

        private void setFigurePoolNameFigureGen(VerticalLabel fig) {
            this.fPoolNameFigure = fig;
        }

        protected void setFigurePoolNameFigure(VerticalLabel fig) {
            this.setFigurePoolNameFigureGen(fig);
            fig.setText(BpmnDiagramMessages.PoolEditPart_default_label);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

