/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.dnd.file;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stp.bpmn.dnd.IEAnnotationDecorator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileEAnnotationDecorator
implements IEAnnotationDecorator {
    private static boolean ADAPTER_FACTORIES_WERE_LOADED = false;

    public String getAssociatedAnnotationSource() {
        return "genericFile";
    }

    public IDecoratorTarget.Direction getDirection(EditPart part, EModelElement elt, EAnnotation ann) {
        return IDecoratorTarget.Direction.SOUTH_WEST;
    }

    public ImageDescriptor getImageDescriptor(EditPart part, EModelElement element, EAnnotation annotation) {
        ImageRegistry customizer;
        if (element == null) {
            if (PlatformUI.isWorkbenchRunning()) {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
            }
            return null;
        }
        String filePath = (String)annotation.getDetails().get((Object)"projectRelativePath");
        if (filePath == null) {
            return null;
        }
        IProject currentProject = WorkspaceSynchronizer.getFile((Resource)element.eResource()).getProject();
        IResource ourResource = currentProject.findMember(filePath);
        if (ourResource == null) {
            ourResource = currentProject.getFile(filePath);
        }
        if (!ADAPTER_FACTORIES_WERE_LOADED) {
            ADAPTER_FACTORIES_WERE_LOADED = true;
            this.forceLoadAdapterFactoryForResourceToImageRegistry();
        }
        if ((customizer = (ImageRegistry)Platform.getAdapterManager().getAdapter((Object)ourResource, ImageRegistry.class)) != null) {
            return customizer.getDescriptor(ourResource.getFileExtension());
        }
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter((Object)ourResource, IWorkbenchAdapter.class);
        if (adapter == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        }
        return adapter.getImageDescriptor((Object)ourResource);
    }

    public IFigure getToolTip(EditPart part, EModelElement element, EAnnotation annotation) {
        return new Label(((String)annotation.getDetails().get((Object)"projectRelativePath")).toString());
    }

    private void forceLoadAdapterFactoryForResourceToImageRegistry() {
        Class[] cl;
        HashMap factories = ((AdapterManager)Platform.getAdapterManager()).getFactories();
        Class[] classArray = cl = ((AdapterManager)Platform.getAdapterManager()).computeClassOrder(IResource.class);
        int n = cl.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            List clfactories = (List)factories.get(c.getName());
            if (clfactories != null) {
                block3: for (Object f : clfactories) {
                    String[] adapterNames;
                    if (!(f instanceof IAdapterFactoryExt) || (adapterNames = ((IAdapterFactoryExt)f).getAdapterNames()) == null) continue;
                    String[] stringArray = adapterNames;
                    int n3 = adapterNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String adapterName = stringArray[n4];
                        if ("org.eclipse.jface.resource.ImageRegistry".equals(adapterName) || "org.eclipse.ui.model.IWorkbenchAdapter".equals(adapterName)) {
                            try {
                                ((IAdapterFactoryExt)f).loadFactory(true);
                            }
                            catch (Exception e) {
                                System.err.println("Unable to load a Adapterfactory for ImageRegistry factory: " + e.getMessage() + " for " + c.getName());
                            }
                            continue block3;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }
}

