/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Tool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.Group2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.GroupEditPart;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.figures.activities.ActivityDiamondFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityNodeFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityOvalFigure;
import org.eclipse.stp.bpmn.handles.ConnectionHandleEx;
import org.eclipse.stp.bpmn.handles.ConnectionHandleForAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandleEditPolicyEx
extends DiagramAssistantEditPolicy {
    private static boolean isHandleCurrentlyShowing = false;
    private OwnerMovedListener ownerMovedListener = new OwnerMovedListener();
    private List<ConnectionHandle> handles = null;
    private static int HANDLE_SPACING = 15;

    protected boolean isDiagramAssistant(Object object) {
        return object instanceof ConnectionHandle;
    }

    protected List<ConnectionHandle> getHandleFigures(int borderSide) {
        ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>();
        List<IElementType> srcEltTypes = this.getSourceElementTypes();
        List<IElementType> tgtEltTypes = this.getTargetElementTypes();
        switch (borderSide) {
            case 8: {
                if (!tgtEltTypes.contains(BpmnElementTypes.SequenceEdge_3001)) break;
                list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, this.buildTooltip(ConnectionHandle.HandleDirection.INCOMING)));
                break;
            }
            case 16: {
                if (!srcEltTypes.contains(BpmnElementTypes.SequenceEdge_3001)) break;
                list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, this.buildTooltip(ConnectionHandle.HandleDirection.OUTGOING)));
            }
        }
        this.setMessagingEdgeHandleFigures(borderSide, list, srcEltTypes, tgtEltTypes);
        this.setAssociationHandleFigures(borderSide, list, srcEltTypes, tgtEltTypes);
        return list;
    }

    protected List<IElementType> getTargetElementTypes() {
        return ModelingAssistantService.getInstance().getRelTypesOnTarget((IAdaptable)this.getHost());
    }

    protected List<IElementType> getSourceElementTypes() {
        return ModelingAssistantService.getInstance().getRelTypesOnSource((IAdaptable)this.getHost());
    }

    protected void setMessagingEdgeHandleFigures(int borderSide, List<ConnectionHandle> list, List<IElementType> srcEltTypes, List<IElementType> tgtEltTypes) {
        switch (borderSide) {
            case 1: 
            case 4: {
                if (tgtEltTypes.contains(BpmnElementTypes.MessagingEdge_3002)) {
                    list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, this.buildTooltip(ConnectionHandle.HandleDirection.INCOMING)));
                }
                if (!srcEltTypes.contains(BpmnElementTypes.MessagingEdge_3002)) break;
                list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, this.buildTooltip(ConnectionHandle.HandleDirection.OUTGOING)));
            }
        }
    }

    protected void setAssociationHandleFigures(int borderSide, List<ConnectionHandle> list, List<IElementType> srcEltTypes, List<IElementType> tgtEltTypes) {
        if (srcEltTypes.contains(BpmnElementTypes.Association_3003)) {
            list.add(new ConnectionHandleForAssociation((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, "Association"));
        } else if (tgtEltTypes.contains(BpmnElementTypes.Association_3003)) {
            list.add(new ConnectionHandleForAssociation((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, "Association"));
        }
    }

    protected String buildTooltip(ConnectionHandle.HandleDirection direction) {
        return "";
    }

    public void activate() {
        super.activate();
        ((IGraphicalEditPart)this.getHost()).getFigure().addFigureListener((FigureListener)this.ownerMovedListener);
    }

    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeFigureListener((FigureListener)this.ownerMovedListener);
        super.deactivate();
    }

    protected void showDiagramAssistant(Point referencePoint) {
        isHandleCurrentlyShowing = true;
        if (referencePoint == null) {
            referencePoint = this.getHostFigure().getBounds().getRight();
        }
        ConnectionHandleLocator locator = this.getConnectionHandleLocator(referencePoint);
        this.handles = this.getHandleFigures(locator.getBorderSide());
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        for (ConnectionHandle handle : this.handles) {
            handle.setLocator((Locator)locator);
            locator.addHandle(handle);
            handle.addMouseMotionListener((MouseMotionListener)this);
            layer.add((IFigure)handle);
            this.getHost().getViewer().getVisualPartMap().put(handle, this.getHost());
        }
        if (!this.shouldAvoidHidingDiagramAssistant()) {
            this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelay());
        }
    }

    protected boolean isPreferenceOn() {
        String prefName = this.getThePreferenceName();
        if (prefName == null) {
            return true;
        }
        IPreferenceStore preferenceStore = (IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore();
        return preferenceStore.getBoolean(prefName);
    }

    protected String getThePreferenceName() {
        return "Global.showConnectionHandles";
    }

    protected void hideDiagramAssistant() {
        isHandleCurrentlyShowing = false;
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        for (ConnectionHandle handle : this.handles) {
            handle.removeMouseMotionListener((MouseMotionListener)this);
            layer.remove((IFigure)handle);
            this.getHost().getViewer().getVisualPartMap().remove(handle);
        }
        this.handles = null;
    }

    private boolean isSelectionToolActive() {
        Tool theTool;
        return this.getHost().getParent() != null && (theTool = this.getHost().getViewer().getEditDomain().getActiveTool()) != null && theTool instanceof SelectionTool;
    }

    protected Rectangle getOwnerBounds(IFigure hostFigure) {
        Rectangle bounds = null;
        for (Object child : hostFigure.getChildren()) {
            if (child instanceof ActivityNodeFigure) {
                for (Object childOfChild : ((ActivityNodeFigure)child).getChildren()) {
                    if (!(childOfChild instanceof ActivityDiamondFigure) && !(childOfChild instanceof ActivityOvalFigure)) continue;
                    bounds = ((IFigure)childOfChild).getBounds().getCopy();
                    break;
                }
            }
            if (bounds != null) break;
        }
        if (bounds == null) {
            bounds = hostFigure.getBounds().getCopy();
        }
        bounds.x -= bounds.width / 4;
        bounds.y -= bounds.height / 4;
        bounds.width += bounds.width / 4;
        bounds.height += bounds.height / 4;
        return bounds;
    }

    protected boolean shouldShowDiagramAssistant() {
        if (isHandleCurrentlyShowing) {
            return false;
        }
        if (this.getAppearanceDelay() < 0) {
            return false;
        }
        if (!super.shouldShowDiagramAssistant()) {
            return false;
        }
        if (this.handles != null || !this.isSelectionToolActive()) {
            return false;
        }
        if (this.getMouseLocation() == null) {
            return false;
        }
        Point mouse = this.getMouseLocation().getCopy();
        Rectangle bounds = this.getOwnerBounds(this.getHostFigure());
        if (this.getHost() instanceof GroupEditPart || this.getHost() instanceof Group2EditPart) {
            boolean onY;
            boolean onX = Math.abs(mouse.x - bounds.x) < 5 || Math.abs(mouse.x - (bounds.x + bounds.width)) < 5;
            boolean bl = onY = Math.abs(mouse.y - bounds.y) < 5 || Math.abs(mouse.y - (bounds.y + bounds.height)) < 5;
            return onX || onY;
        }
        return bounds.contains(mouse);
    }

    protected ConnectionHandleLocator getConnectionHandleLocator(Point referencePoint) {
        IFigure handleBoundFig = null;
        IGraphicalEditPart gap = (IGraphicalEditPart)this.getHost();
        if (this.getHost() instanceof ActivityEditPart) {
            ActivityEditPart aep = (ActivityEditPart)this.getHost();
            handleBoundFig = aep.getHandleBoundsFigure();
        } else if (this.getHost() instanceof Activity2EditPart) {
            Activity2EditPart aep2 = (Activity2EditPart)this.getHost();
            handleBoundFig = aep2.getHandleBoundsFigure();
        }
        if (handleBoundFig != null) {
            Rectangle bounds = handleBoundFig.getBounds().getCopy();
            if (bounds.x == 0) {
                handleBoundFig.translateToAbsolute((Translatable)bounds);
                gap.getFigure().translateToRelative((Translatable)bounds);
            }
            if (bounds.width != 0 && bounds.height != 0) {
                int borderSide = 0;
                boolean overFirstDiag = this.isOverALine(bounds.getBottomRight(), bounds.getTopLeft(), referencePoint);
                boolean overSecondDiag = this.isOverALine(bounds.getTopRight(), bounds.getBottomLeft(), referencePoint);
                if (overFirstDiag) {
                    if (overSecondDiag) {
                        referencePoint = bounds.getTop().getCopy();
                        borderSide = 1;
                    } else {
                        referencePoint = bounds.getRight().getCopy();
                        borderSide = 16;
                    }
                } else if (overSecondDiag) {
                    referencePoint = bounds.getLeft().getCopy();
                    borderSide = 8;
                } else {
                    referencePoint = bounds.getBottom().getCopy();
                    borderSide = 4;
                }
                this.getHostFigure().translateToAbsolute((Translatable)referencePoint);
                return new ConnectionHandleLocatorEx(this.getHostFigure(), referencePoint, borderSide);
            }
        }
        return new ConnectionHandleLocator(this.getHostFigure(), referencePoint);
    }

    private boolean isOverALine(Point firstPoint, Point secondPoint, Point toEvaluate) {
        int yb = secondPoint.y;
        int ya = firstPoint.y;
        int xb = secondPoint.x;
        int xa = firstPoint.x;
        double coeff = (double)(yb - ya) / (double)(xb - xa);
        double constant = (xb * ya - yb * xa) / (xb - xa);
        return (double)toEvaluate.y < coeff * (double)toEvaluate.x + constant;
    }

    protected boolean isDiagramAssistantShowing() {
        return this.handles != null;
    }

    protected int getAppearanceDelay() {
        IPreferenceStore preferenceStore = (IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore();
        int delay = preferenceStore.getInt("bpmn.connection.assistant.appearance.delay");
        return delay > -1 ? delay : 60;
    }

    private class ConnectionHandleLocatorEx
    extends ConnectionHandleLocator {
        private int borderSide;

        public ConnectionHandleLocatorEx(IFigure shape, Point reference, int borderSide) {
            super(shape, reference);
            this.borderSide = borderSide;
        }

        public void relocate(IFigure target) {
            Dimension offset = Dimension.SINGLETON.getCopy();
            switch (this.borderSide) {
                case 1: {
                    offset.height = -target.getBounds().height;
                    break;
                }
                case 16: {
                    break;
                }
                case 4: {
                    break;
                }
                case 8: {
                    offset.width = -target.getBounds().width;
                }
            }
            Point targetLocation = this.getCursorPosition().getCopy().translate(offset);
            target.translateToRelative((Translatable)targetLocation);
            target.setLocation(targetLocation);
            int index = ConnectionHandleEditPolicyEx.this.handles.indexOf(target);
            double centerOffset = (double)index - (double)ConnectionHandleEditPolicyEx.this.handles.size() / 2.0;
            if (this.borderSide == 8 || this.borderSide == 16) {
                target.translate(0, (int)(centerOffset * (double)HANDLE_SPACING));
            } else {
                target.translate((int)(centerOffset * (double)HANDLE_SPACING), 0);
            }
        }

        public int getBorderSide() {
            return this.borderSide;
        }
    }

    private class OwnerMovedListener
    implements FigureListener {
        private OwnerMovedListener() {
        }

        public void figureMoved(IFigure source) {
            ConnectionHandleEditPolicyEx.this.hideDiagramAssistant();
        }
    }
}

