/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.quickfixes.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.bpmn.validation.BpmnValidationPlugin;
import org.eclipse.stp.bpmn.validation.quickfixes.IBpmnMarkerResolutionProvider;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnQuickfixes
implements IMarkerResolutionGenerator2 {
    private static Map<String, Collection<IBpmnMarkerResolutionProvider>> BPMN_DATA_QUICK_FIXES = null;
    private static final String BPMN_QUICKFIX_EXTENSION_POINT_ID = "org.eclipse.stp.bpmn.validation.BpmnMarkerResolutionProvider";

    public static IMarkerResolution[] getTheResolutions(IMarker marker) {
        String quickfixID = null;
        String elementId = null;
        String bpmnId = null;
        try {
            quickfixID = (String)marker.getAttribute("BPMN_QUICK_FIX_RESOLUTION_ID");
            bpmnId = (String)marker.getAttribute("bpmnId");
            elementId = (String)marker.getAttribute("elementId");
        }
        catch (CoreException e) {
            return new IMarkerResolution[0];
        }
        if (quickfixID == null) {
            return new IMarkerResolution[0];
        }
        Collection<IBpmnMarkerResolutionProvider> providers = BpmnQuickfixes.getBpmnQuickfixesProviders().get(quickfixID);
        ArrayList<IMarkerResolution> list = new ArrayList<IMarkerResolution>();
        for (IBpmnMarkerResolutionProvider prov : providers) {
            try {
                Collection<IMarkerResolution> providedResolutions = prov.getMarkerResolution(marker, bpmnId, elementId);
                if (providedResolutions == null) continue;
                for (IMarkerResolution res : providedResolutions) {
                    try {
                        if (res instanceof IMarkerResolutionGenerator2 && !((IMarkerResolutionGenerator2)res).hasResolutions(marker)) continue;
                        list.add(res);
                    }
                    catch (Exception e) {
                        BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", "Execution failure of " + prov + " for marker resolution " + res, (Throwable)e));
                    }
                }
            }
            catch (Exception e) {
                BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", "Execution failure of " + prov, (Throwable)e));
            }
        }
        return list.toArray(new IMarkerResolution[list.size()]);
    }

    public static IMarker[] findOtherMarkers(IMarker[] markers, IMarkerResolution currentResolution) {
        ArrayList<IMarker> otherMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            IMarkerResolution[] iMarkerResolutionArray = BpmnQuickfixes.getTheResolutions(m);
            int n3 = iMarkerResolutionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMarkerResolution res = iMarkerResolutionArray[n4];
                if (res == currentResolution) {
                    otherMarkers.add(m);
                }
                ++n4;
            }
            ++n2;
        }
        return otherMarkers.toArray(new IMarker[otherMarkers.size()]);
    }

    public boolean hasResolutions(IMarker marker) {
        String quickfixID;
        try {
            quickfixID = (String)marker.getAttribute("BPMN_QUICK_FIX_RESOLUTION_ID");
        }
        catch (CoreException e) {
            return false;
        }
        if (quickfixID == null) {
            return false;
        }
        return BpmnQuickfixes.getBpmnQuickfixesProviders().containsKey(quickfixID);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return BpmnQuickfixes.getTheResolutions(marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Collection<IBpmnMarkerResolutionProvider>> getBpmnQuickfixesProviders() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        synchronized (iExtensionRegistry) {
            if (BPMN_DATA_QUICK_FIXES != null) {
                return BPMN_DATA_QUICK_FIXES;
            }
            BPMN_DATA_QUICK_FIXES = new HashMap<String, Collection<IBpmnMarkerResolutionProvider>>();
            IConfigurationElement[] configElems = Platform.getExtensionRegistry().getConfigurationElementsFor(BPMN_QUICKFIX_EXTENSION_POINT_ID);
            int j = configElems.length - 1;
            while (j >= 0) {
                try {
                    IConfigurationElement el = configElems[j];
                    IBpmnMarkerResolutionProvider resProv = (IBpmnMarkerResolutionProvider)el.createExecutableExtension("class");
                    String id = el.getAttribute("id");
                    Collection<IBpmnMarkerResolutionProvider> coll = BPMN_DATA_QUICK_FIXES.get(id);
                    if (coll == null) {
                        coll = new HashSet<IBpmnMarkerResolutionProvider>();
                        BPMN_DATA_QUICK_FIXES.put(id, coll);
                    }
                    coll.add(resProv);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                --j;
            }
            return BPMN_DATA_QUICK_FIXES;
        }
    }
}

