/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.part;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.eid.datamodel.ComponentModel;
import org.eclipse.stp.eid.datamodel.ESB;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.Namespace;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditor;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorPlugin;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorPaletteFactory;
import org.eclipse.stp.eid.datamodel.diagram.part.Messages;
import org.eclipse.stp.eid.datamodel.util.Cimero2EditorPlugin;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;
import org.eclipse.stp.eid.datamodel.util.Parser;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cimero2EditorDiagramEditorUtil {
    public static Map getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public static boolean openDiagram(Resource diagram) throws PartInitException {
        String path = diagram.getURI().toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)new FileEditorInput((IFile)workspaceResource), "org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorID") != null;
        }
        return false;
    }

    public static void setCharset(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to set charset for file " + file.getFullPath(), e);
        }
    }

    public static String getUniqueFileName(IPath containerFullPath, String fileName, String extension) {
        if (containerFullPath == null) {
            containerFullPath = new Path("");
        }
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = "default";
        }
        IPath filePath = containerFullPath.append(fileName);
        if (extension != null && !extension.equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension(extension);
        }
        extension = filePath.getFileExtension();
        fileName = filePath.removeFileExtension().lastSegment();
        int i = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().exists(filePath)) {
            filePath = containerFullPath.append(String.valueOf(fileName) + ++i);
            if (extension == null) continue;
            filePath = filePath.addFileExtension(extension);
        }
        return filePath.lastSegment();
    }

    public static void runWizard(Shell shell, Wizard wizard, String settingsKey) {
        IDialogSettings pluginDialogSettings = Cimero2EditorDiagramEditorPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardDialogSettings = pluginDialogSettings.getSection(settingsKey);
        if (wizardDialogSettings == null) {
            wizardDialogSettings = pluginDialogSettings.addNewSection(settingsKey);
        }
        wizard.setDialogSettings(wizardDialogSettings);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
    }

    public static Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        progressMonitor.beginTask(Messages.Cimero2EditorDiagramEditorUtil_CreateDiagramProgressTask, 3);
        Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);
        Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        String diagramName = diagramURI.lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.Cimero2EditorDiagramEditorUtil_CreateDiagramCommandLabel, Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Graph model = Cimero2EditorDiagramEditorUtil.createInitialModel();
                Cimero2EditorDiagramEditorUtil.attachModelToResource(model, modelResource);
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)"Cimero2Editor", (PreferencesHint)Cimero2EditorDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement((EObject)model);
                }
                try {
                    modelResource.save(Cimero2EditorDiagramEditorUtil.getSaveOptions());
                    diagramResource.save(Cimero2EditorDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException e) {
                    Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        Cimero2EditorDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        Cimero2EditorDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)diagramResource));
        return diagramResource;
    }

    public static Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor, String esbName) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        progressMonitor.beginTask(Messages.Cimero2EditorDiagramEditorUtil_CreateDiagramProgressTask, 3);
        Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);
        Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        String diagramName = diagramURI.lastSegment();
        String graphName = diagramURI.lastSegment().replace("." + diagramURI.fileExtension(), "");
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.Cimero2EditorDiagramEditorUtil_CreateDiagramCommandLabel, Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Graph model = Cimero2EditorDiagramEditorUtil.createInitialModel();
                model.setName(graphName);
                Cimero2EditorDiagramEditorUtil.attachModelToResource(model, modelResource);
                ESB esb = Cimero2EditorDiagramEditorUtil.createInitialESB(esbName);
                Cimero2EditorDiagramEditorUtil.attachESBToResource(esb, modelResource);
                Cimero2EditorDiagramEditorUtil.attachDefaultNamespacesToResource(esbName, model);
                Cimero2EditorDiagramEditorUtil.attachComponentsModelToResource(esbName, modelResource);
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)"Cimero2Editor", (PreferencesHint)Cimero2EditorDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement((EObject)model);
                }
                try {
                    modelResource.save(Cimero2EditorDiagramEditorUtil.getSaveOptions());
                    diagramResource.save(Cimero2EditorDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException e) {
                    Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        Cimero2EditorDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        Cimero2EditorDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)diagramResource));
        return diagramResource;
    }

    private static Graph createInitialModel() {
        return cimero2Factory.eINSTANCE.createGraph();
    }

    private static void attachModelToResource(Graph model, Resource resource) {
        resource.getContents().add((Object)model);
    }

    private static void attachESBToResource(ESB esb, Resource modelResource) {
        modelResource.getContents().add((Object)esb);
    }

    private static void attachDefaultNamespacesToResource(String esbName, Graph model) {
        int i = 0;
        while (i < cimero2Factory.eINSTANCE.getNamespaceList(esbName).size()) {
            Namespace newNamespace = cimero2Factory.eINSTANCE.createNamespace();
            newNamespace.setPrefix(((Namespace)cimero2Factory.eINSTANCE.getNamespaceList(esbName).get(i)).getPrefix());
            newNamespace.setValue(((Namespace)cimero2Factory.eINSTANCE.getNamespaceList(esbName).get(i)).getValue());
            model.getNamespaces().add((Object)newNamespace);
            ++i;
        }
    }

    private static void attachComponentsModelToResource(String esbName, Resource modelResource) {
        Parser.populateResource((String)esbName, (Resource)modelResource);
    }

    public static void selectElementsInDiagram(IDiagramWorkbenchPart diagramPart, List editParts) {
        diagramPart.getDiagramGraphicalViewer().deselectAll();
        EditPart firstPrimary = null;
        for (EditPart nextPart : editParts) {
            diagramPart.getDiagramGraphicalViewer().appendSelection(nextPart);
            if (firstPrimary != null || !(nextPart instanceof IPrimaryEditPart)) continue;
            firstPrimary = nextPart;
        }
        if (!editParts.isEmpty()) {
            diagramPart.getDiagramGraphicalViewer().reveal(firstPrimary != null ? firstPrimary : (EditPart)editParts.get(0));
        }
    }

    private static int findElementsInDiagramByID(DiagramEditPart diagramPart, EObject element, List editPartCollector) {
        EditPart editPart;
        IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)diagramPart.getViewer();
        int intialNumOfEditParts = editPartCollector.size();
        if (element instanceof View && (editPart = (EditPart)viewer.getEditPartRegistry().get(element)) != null) {
            editPartCollector.add(editPart);
            return 1;
        }
        String elementID = EMFCoreUtil.getProxyID((EObject)element);
        List associatedParts = viewer.findEditPartsForElement(elementID, IGraphicalEditPart.class);
        for (EditPart nextPart : associatedParts) {
            EditPart parentPart = nextPart.getParent();
            while (parentPart != null && !associatedParts.contains(parentPart)) {
                parentPart = parentPart.getParent();
            }
            if (parentPart != null) continue;
            editPartCollector.add(nextPart);
        }
        if (intialNumOfEditParts == editPartCollector.size()) {
            if (!associatedParts.isEmpty()) {
                editPartCollector.add(associatedParts.iterator().next());
            } else if (element.eContainer() != null) {
                return Cimero2EditorDiagramEditorUtil.findElementsInDiagramByID(diagramPart, element.eContainer(), editPartCollector);
            }
        }
        return editPartCollector.size() - intialNumOfEditParts;
    }

    public static View findView(DiagramEditPart diagramEditPart, EObject targetElement, LazyElement2ViewMap lazyElement2ViewMap) {
        boolean hasStructuralURI = false;
        if (targetElement.eResource() instanceof XMLResource) {
            hasStructuralURI = ((XMLResource)targetElement.eResource()).getID(targetElement) == null;
        }
        View view = null;
        if (hasStructuralURI && !lazyElement2ViewMap.getElement2ViewMap().isEmpty()) {
            view = (View)lazyElement2ViewMap.getElement2ViewMap().get(targetElement);
        } else if (Cimero2EditorDiagramEditorUtil.findElementsInDiagramByID(diagramEditPart, targetElement, lazyElement2ViewMap.editPartTmpHolder) > 0) {
            EditPart editPart = (EditPart)lazyElement2ViewMap.editPartTmpHolder.get(0);
            lazyElement2ViewMap.editPartTmpHolder.clear();
            view = editPart.getModel() instanceof View ? (View)editPart.getModel() : null;
        }
        return view == null ? diagramEditPart.getDiagramView() : view;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        IEditorPart editor = iWorkbenchPage.getActiveEditor();
        return editor;
    }

    public static Diagram getDiagram() {
        IEditorPart editor = Cimero2EditorDiagramEditorUtil.getActiveEditor();
        if (editor != null) {
            IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)editor;
            Diagram diagram = diagramPart.getDiagram();
            return diagram;
        }
        return null;
    }

    public ResourceSet getResourceSet() {
        return Cimero2EditorDiagramEditorUtil.getDiagram().eResource().getResourceSet();
    }

    public static Resource getModelResource() {
        Diagram diagram;
        Resource modelResource = null;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null && iWorkbenchPage.getActiveEditor() != null && (diagram = Cimero2EditorDiagramEditorUtil.getDiagram()) != null) {
            EList resources = Cimero2EditorDiagramEditorUtil.getDiagram().eResource().getResourceSet().getResources();
            int i = 0;
            while (i < resources.size() && modelResource == null) {
                if (((Resource)resources.get(i)).getURI().path().compareTo(Cimero2EditorDiagramEditorUtil.getDiagram().eResource().getURI().path()) != 0) {
                    modelResource = (Resource)resources.get(i);
                }
                ++i;
            }
        }
        return modelResource;
    }

    private static ESB createInitialESB(String esbName) {
        ESB esb = cimero2Factory.eINSTANCE.createESB();
        esb.setName(esbName);
        return esb;
    }

    public static void addNewComponentModelToResource(Resource modelResource, ESB esb, List<ComponentModel> resourceComponentModels) {
        ArrayList componentModelFiles = new ArrayList();
        ArrayList<String> uptodateComponentModels = new ArrayList<String>();
        HashMap<String, String> modelMap = new HashMap<String, String>();
        try {
            componentModelFiles = Parser.scanDir((String)(String.valueOf(Cimero2EditorPlugin.cimeroDirPath) + File.separator + "componentModel"));
            int i = 0;
            while (i < componentModelFiles.size()) {
                String componentModelName = Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"component-name");
                if (Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"esb") != null && componentModelName != null && esb.getName().compareTo(Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"esb")) == 0) {
                    modelMap.put(componentModelName, (String)componentModelFiles.get(i));
                    uptodateComponentModels.add(componentModelName);
                }
                ++i;
            }
        }
        catch (IOException e) {
            LoggerTool.logger.warning("No cimero directory to scan, all your components data where maybe lost" + e.getStackTrace().toString());
        }
        int j = 0;
        while (j < uptodateComponentModels.size()) {
            if (!Cimero2EditorDiagramEditorUtil.modelExistInResource(resourceComponentModels, (String)uptodateComponentModels.get(j))) {
                SAXBuilder sxb = new SAXBuilder();
                sxb.setValidation(true);
                sxb.setFeature("http://apache.org/xml/features/validation/schema", true);
                sxb.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                String fileName = (String)modelMap.get(uptodateComponentModels.get(j));
                File componentModelFile = new File(fileName);
                try {
                    Document xmlFile = sxb.build(componentModelFile);
                    Element racine = xmlFile.getRootElement();
                    ComponentModel componentModelToAdd = Parser.createComponent((Element)racine, (ESB)esb);
                    Cimero2EditorDiagramEditorUtil.addModelToResource(modelResource, componentModelToAdd);
                }
                catch (JDOMException e) {
                    LoggerTool.logger.warning(componentModelFile + " is not well-formed.");
                    LoggerTool.logger.warning(e.getMessage());
                }
                catch (IOException e) {
                    LoggerTool.logger.severe("Input/output error");
                    LoggerTool.logger.severe("during the call to constructor.parse(xml)");
                }
            }
            ++j;
        }
    }

    private static void addModelToResource(Resource modelResource, ComponentModel componentModel) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.getEditingDomain(modelResource.getResourceSet());
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Add component model", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                modelResource.getContents().add((Object)componentModel);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to add the component " + componentModel.getName(), e);
        }
    }

    private static boolean modelExistInResource(List<ComponentModel> resourceComponentModels, String componentName) {
        boolean found = false;
        int i = 0;
        while (i < resourceComponentModels.size() && !found) {
            if (resourceComponentModels.get(i).getName().compareTo(componentName) == 0) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public static void addElementToPalette(String type, String picture, String name) {
        PaletteRoot content = new PaletteRoot();
        List containers = Cimero2EditorDiagramEditor.getPaletteRoot().getChildren();
        ToolEntry entry = Cimero2EditorPaletteFactory.createComponentInstanceCreationTool(name, picture);
        if (type.compareTo("BC") == 0) {
            ((PaletteContainer)containers.get(3)).add((PaletteEntry)entry);
        } else {
            ((PaletteContainer)containers.get(2)).add((PaletteEntry)entry);
        }
        int i = 0;
        while (i < containers.size()) {
            content.add((PaletteEntry)containers.get(i));
            ++i;
        }
        PaletteService.getInstance().createPalette(Cimero2EditorDiagramEditorUtil.getActiveEditor(), (Object)content);
        Cimero2EditorDiagramEditor.setPaletteRoot(content);
    }

    public static void updatePaletteContent(String currentEsb) {
        PaletteRoot content = new PaletteRoot();
        List containers = Cimero2EditorDiagramEditor.getPaletteRoot().getChildren();
        PaletteEntry entry = null;
        try {
            ArrayList componentModelFiles = Parser.scanDir((String)(String.valueOf(Cimero2EditorPlugin.cimeroDirPath) + File.separator + "componentModel"));
            int i = 0;
            while (i < componentModelFiles.size()) {
                String componentModelName = Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"component-name");
                if (currentEsb.compareTo(Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"esb")) == 0) {
                    String picture = Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"picture");
                    String type = Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"component-type");
                    Cimero2EditorPaletteFactory.createComponentInstanceCreationTool(componentModelName, picture);
                    if (type.compareTo("BC") == 0) {
                        ((PaletteContainer)containers.get(3)).add(entry);
                    } else {
                        ((PaletteContainer)containers.get(2)).add(entry);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            LoggerTool.logger.warning("No cimero directory to scan, all your components data where maybe lost" + e.getStackTrace().toString());
        }
        int i = 0;
        while (i < containers.size()) {
            content.add((PaletteEntry)containers.get(i));
            ++i;
        }
        PaletteService.getInstance().createPalette(Cimero2EditorDiagramEditorUtil.getActiveEditor(), (Object)content);
        Cimero2EditorDiagramEditor.setPaletteRoot(content);
    }

    static /* synthetic */ Graph access$0() {
        return Cimero2EditorDiagramEditorUtil.createInitialModel();
    }

    static /* synthetic */ void access$1(Graph graph, Resource resource) {
        Cimero2EditorDiagramEditorUtil.attachModelToResource(graph, resource);
    }

    static /* synthetic */ ESB access$2(String string) {
        return Cimero2EditorDiagramEditorUtil.createInitialESB(string);
    }

    static /* synthetic */ void access$3(ESB eSB, Resource resource) {
        Cimero2EditorDiagramEditorUtil.attachESBToResource(eSB, resource);
    }

    static /* synthetic */ void access$4(String string, Graph graph) {
        Cimero2EditorDiagramEditorUtil.attachDefaultNamespacesToResource(string, graph);
    }

    static /* synthetic */ void access$5(String string, Resource resource) {
        Cimero2EditorDiagramEditorUtil.attachComponentsModelToResource(string, resource);
    }

    public static class LazyElement2ViewMap {
        private Map element2ViewMap;
        private View scope;
        private Set elementSet;
        public final List editPartTmpHolder = new ArrayList();

        public LazyElement2ViewMap(View scope, Set elements) {
            this.scope = scope;
            this.elementSet = elements;
        }

        public final Map getElement2ViewMap() {
            if (this.element2ViewMap == null) {
                this.element2ViewMap = new HashMap();
                for (EObject element : this.elementSet) {
                    View view;
                    if (!(element instanceof View) || (view = (View)element).getDiagram() != this.scope.getDiagram()) continue;
                    this.element2ViewMap.put(element, element);
                }
                LazyElement2ViewMap.buildElement2ViewMap(this.scope, this.element2ViewMap, this.elementSet);
            }
            return this.element2ViewMap;
        }

        static Map buildElement2ViewMap(View parentView, Map element2ViewMap, Set elements) {
            if (elements.size() == element2ViewMap.size()) {
                return element2ViewMap;
            }
            if (parentView.isSetElement() && !element2ViewMap.containsKey(parentView.getElement()) && elements.contains(parentView.getElement())) {
                element2ViewMap.put(parentView.getElement(), parentView);
                if (elements.size() == element2ViewMap.size()) {
                    return element2ViewMap;
                }
            }
            Iterator it = parentView.getChildren().iterator();
            while (it.hasNext()) {
                LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
                if (elements.size() != element2ViewMap.size()) continue;
                return element2ViewMap;
            }
            it = parentView.getSourceEdges().iterator();
            while (it.hasNext()) {
                LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
                if (elements.size() != element2ViewMap.size()) continue;
                return element2ViewMap;
            }
            it = parentView.getSourceEdges().iterator();
            while (it.hasNext()) {
                LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
                if (elements.size() != element2ViewMap.size()) continue;
                return element2ViewMap;
            }
            return element2ViewMap;
        }
    }
}

