/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.desccriptor;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.Connection;
import org.eclipse.stp.eid.datamodel.provider.Cimero2EditorEditPlugin;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RepeatablePropertyDeleteDialogCellEditor
extends DialogCellEditor {
    private ComponentInstanceProperty propertyToDelete;

    protected final void updateContents(Object value) {
        super.updateContents((Object)"Click to delete this property");
    }

    protected RepeatablePropertyDeleteDialogCellEditor(Composite parent, ComponentInstanceProperty property) {
        super(parent);
        this.propertyToDelete = property;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        if (this.propertyToDelete != null) {
            Diagram diagram = null;
            try {
                if (Cimero2EditorEditPlugin.INSTANCE.getActiveEditor() != null) {
                    IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)Cimero2EditorEditPlugin.INSTANCE.getActiveEditor();
                    diagram = diagramPart.getDiagram();
                }
                if (diagram != null) {
                    TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.getEditingDomain(diagram.eResource().getResourceSet());
                    AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Delete property", Collections.EMPTY_LIST){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Connection connectionToDelete;
                            ComponentInstanceProperty repeatablePropertyFather = (ComponentInstanceProperty)RepeatablePropertyDeleteDialogCellEditor.this.propertyToDelete.getSuperProperty();
                            ComponentInstance componentInstance = RepeatablePropertyDeleteDialogCellEditor.this.propertyToDelete.getComponentInstance();
                            if (RepeatablePropertyDeleteDialogCellEditor.this.propertyToDelete.getTheUsedTargetService() != null && (connectionToDelete = RepeatablePropertyDeleteDialogCellEditor.this.propertyToDelete.getTheUsedTargetService().getConnection()) != null) {
                                this.deleteConnection(connectionToDelete, editingDomain, monitor);
                            }
                            if (repeatablePropertyFather != null) {
                                repeatablePropertyFather.deleteSubProperty(RepeatablePropertyDeleteDialogCellEditor.this.propertyToDelete);
                            } else {
                                componentInstance.deleteProperty(RepeatablePropertyDeleteDialogCellEditor.this.propertyToDelete);
                            }
                            int iProperty = 0;
                            while (iProperty < componentInstance.getProperties().size()) {
                                ((ComponentInstanceProperty)componentInstance.getProperties().get(iProperty)).reInit();
                                ++iProperty;
                            }
                            return CommandResult.newOKCommandResult();
                        }

                        private void deleteConnection(Connection connectionToDelete, TransactionalEditingDomain editingDomain2, IProgressMonitor monitor) {
                            ICommand command;
                            IElementType type = ElementTypeRegistry.getInstance().getElementType((EObject)connectionToDelete);
                            DestroyElementRequest destroy = new DestroyElementRequest(editingDomain2, (EObject)connectionToDelete, false);
                            ICommand iCommand = command = type != null ? type.getEditCommand((IEditCommandRequest)destroy) : null;
                            if (command != null) {
                                try {
                                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, monitor, null);
                                }
                                catch (ExecutionException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                LoggerTool.logger.warning("Be carrefull, the delete command is null, it will maybe result an error !");
                            }
                        }
                    };
                    try {
                        OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
                    }
                    catch (ExecutionException e) {
                        LoggerTool.logger.warning("Unable to delete the property" + this.propertyToDelete.getName() + "\n" + (Object)((Object)e));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fireEditorValueChanged(true, true);
        return null;
    }

    protected Button createButton(Composite parent) {
        Button button = super.createButton(parent);
        Image img = this.getIconImage("minus");
        button.setSize(18, 18);
        button.setImage(img);
        button.setText("");
        return button;
    }

    private Image getIconImage(String imageName) {
        return this.getImageDescriptor(imageName).createImage();
    }

    private ImageDescriptor getImageDescriptor(String imageName) {
        ImageDescriptor imageDesc = Cimero2EditorEditPlugin.getBundledImageDescriptor("icons/full/obj16/" + imageName + ".gif");
        return imageDesc;
    }

    static /* synthetic */ ComponentInstanceProperty access$0(RepeatablePropertyDeleteDialogCellEditor repeatablePropertyDeleteDialogCellEditor) {
        return repeatablePropertyDeleteDialogCellEditor.propertyToDelete;
    }
}

