/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.provider;

import org.eclipse.emf.common.util.EList;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.Connection;
import org.eclipse.stp.eid.datamodel.Container;
import org.eclipse.stp.eid.datamodel.MEPType;
import org.eclipse.stp.eid.datamodel.Namespace;
import org.eclipse.stp.eid.datamodel.desccriptor.FileBrowsingPropertyDescriptor;
import org.eclipse.stp.eid.datamodel.desccriptor.MyComboBoxPropertyDescriptor;
import org.eclipse.stp.eid.datamodel.desccriptor.MyPropertyDescriptor;
import org.eclipse.stp.eid.datamodel.desccriptor.MyTextPropertyDescriptor;
import org.eclipse.stp.eid.datamodel.desccriptor.MyUnsettablePropertyDescriptor;
import org.eclipse.stp.eid.datamodel.desccriptor.RepeatablePropertyAddDescriptor;
import org.eclipse.stp.eid.datamodel.desccriptor.RepeatablePropertyDeleteDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptorProvider {
    public static IPropertyDescriptor createRepeatableAddDescriptor(String name, String label, ComponentInstanceProperty property) {
        RepeatablePropertyAddDescriptor repeatableDesciptor = new RepeatablePropertyAddDescriptor(name, label, property);
        String category = null;
        category = property != null && property.getSuperProperty() != null ? property.getSuperProperty().getName() : "Component";
        repeatableDesciptor.setCategory(category);
        repeatableDesciptor.setDescription(property.getModel().getDescription());
        return repeatableDesciptor;
    }

    public static IPropertyDescriptor createRepeatableDeleteDescriptor(String name, String label, ComponentInstanceProperty property) {
        RepeatablePropertyDeleteDescriptor repeatableDesciptor = new RepeatablePropertyDeleteDescriptor(name, label, property);
        String category = null;
        category = property != null && property.getSuperProperty() != null ? property.getSuperProperty().getName() : "Component";
        repeatableDesciptor.setCategory(category);
        repeatableDesciptor.setDescription(property.getModel().getDescription());
        return repeatableDesciptor;
    }

    public static IPropertyDescriptor createComboDescriptor(String name, String label, String[] comboValues, ComponentInstanceProperty property) {
        MyComboBoxPropertyDescriptor comboDescriptor = new MyComboBoxPropertyDescriptor(name, label, comboValues, property);
        String category = null;
        category = property != null && property.getSuperProperty() != null ? property.getSuperProperty().getName() : "Component";
        comboDescriptor.setCategory(category);
        comboDescriptor.setDescription(property.getModel().getDescription());
        return comboDescriptor;
    }

    public static IPropertyDescriptor createUnsettableDescriptor(String name, String label, ComponentInstanceProperty property) {
        MyUnsettablePropertyDescriptor unsettableDescriptor = new MyUnsettablePropertyDescriptor(name, label, property);
        String category = null;
        category = property != null && property.getSuperProperty() != null ? property.getSuperProperty().getName() : "Component";
        unsettableDescriptor.setCategory(category);
        unsettableDescriptor.setDescription(property.getModel().getDescription());
        return unsettableDescriptor;
    }

    public static IPropertyDescriptor createFileBrowsingDescriptor(String name, String label, ComponentInstanceProperty property) {
        FileBrowsingPropertyDescriptor fileBrowsingDescriptor = new FileBrowsingPropertyDescriptor(name, label, property);
        String category = null;
        category = property != null && property.getSuperProperty() != null ? property.getSuperProperty().getName() : "Component";
        fileBrowsingDescriptor.setCategory(category);
        fileBrowsingDescriptor.setDescription(property.getModel().getDescription());
        return fileBrowsingDescriptor;
    }

    public static IPropertyDescriptor createTextDescriptor(String name, String label, ComponentInstanceProperty property) {
        MyTextPropertyDescriptor textDescriptor = new MyTextPropertyDescriptor(name, label, property);
        String category = null;
        category = property != null && property.getSuperProperty() != null ? property.getSuperProperty().getName() : "Component";
        textDescriptor.setCategory(category);
        textDescriptor.setDescription(property.getModel().getDescription());
        return textDescriptor;
    }

    public static IPropertyDescriptor createDescriptor(String name, String label, ComponentInstanceProperty property) {
        MyPropertyDescriptor descriptor = new MyPropertyDescriptor(name, label, property);
        String category = null;
        category = property.getSuperProperty() != null ? property.getSuperProperty().getName() : "Component";
        descriptor.setCategory(category);
        descriptor.setDescription(property.getModel().getDescription());
        return descriptor;
    }

    public static void notifyConnectionMEPChanged(String MEPString, ComponentInstance componentInstance) {
        int i = 0;
        while (i < componentInstance.getSourceConnections().size()) {
            ((Connection)componentInstance.getSourceConnections().get(i)).setMEPValue(MEPType.get((String)MEPString));
            ++i;
        }
    }

    public static void notifySourceReferenceToExternalComponentChanged(String newValue, String propertyType, ComponentInstance componentInstance) {
        EList sources = componentInstance.getTargetConnections();
        int i = 0;
        while (i < sources.size()) {
            int j = 0;
            while (j < ((Connection)sources.get(i)).getProperties().size()) {
                if (((Connection)sources.get(i)).getProperties().get(j) != null && ((ComponentInstanceProperty)((Connection)sources.get(i)).getProperties().get(j)).getModel().getType().compareTo(propertyType) == 0) {
                    ((ComponentInstanceProperty)((Connection)sources.get(i)).getProperties().get(j)).setValue(newValue);
                }
                ++j;
            }
            ++i;
        }
    }

    public static String[] getNamespacePrefixList(EList<Namespace> namespaces) {
        String[] resultList = new String[namespaces.size() + 1];
        resultList[0] = "";
        int i = 0;
        while (i < namespaces.size()) {
            resultList[i + 1] = ((Namespace)namespaces.get(i)).getPrefix();
            ++i;
        }
        return resultList;
    }

    public static String[] getContainerNameList(EList<Container> containers) {
        String[] resultList = new String[containers.size() + 1];
        resultList[0] = "";
        int i = 0;
        while (i < containers.size()) {
            resultList[i + 1] = ((Container)containers.get(i)).getId();
            ++i;
        }
        return resultList;
    }
}

